<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\Model;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
defined('_JEXEC') or die();

class CheckoutModel extends \Joomla\CMS\MVC\Model\FormModel
{

    private $config;
    private $xmlPath = JPATH_SITE . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR . 'com_eventgallery' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'forms' . DIRECTORY_SEPARATOR;

    public function __construct($config = array(), MVCFactoryInterface $factory = null)
    {
        parent::__construct($config, $factory);
        $this->config = \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main::getInstance();
    }


    public function getForm($data = array(), $loadData = true) {
        return null;
    }
    /**
     * @return \Joomla\CMS\Form\Form
     */
    public function getUserDataForm() {

        $form = $this->loadForm('com_eventgallery.userdata', 'userdata');

        $this->configureUserForm($form);

        return $form;
    }

    /**
     * @return \Joomla\CMS\Form\Form
     */
    public function getUserDataFormWithoutAddress() {
        $form = $this->loadForm('com_eventgallery.userdata_withname','userdata_withname');

        $this->configureUserForm($form);

        return $form;
    }

    public function getLoginForm($data = array(), $loadData = true) {
        return $this->loadForm('com_user.login', JPATH_SITE.'/components/com_users/forms/login.xml', array('load_data' => $loadData));
    }

    /**
     * @param $form
     */
    private function configureUserForm($form): void
    {
        if ($this->config->getCheckout()->isAddressFieldPhonenumberMandatory()) {
            $form->setFieldAttribute('phone', 'required', 'true');
        }

        if ($this->config->getCheckout()->isAddressFieldMessageMandatory()) {
            $form->setFieldAttribute('message', 'required', 'true');
        }
    }

    /**
     * @return \Joomla\CMS\Form\Form
     */
    public function getBillingAddressForm() {
        $form = $this->getAddressForm('billing');
        if (!$this->config->getCheckout()->doEnableBusinessCustomerData()) {
            $form->removeField('billing_taxid');
        }
        return $form;
    }

    /**
     * @return \Joomla\CMS\Form\Form
     */
    public function getShippingAddressForm() {
        return $this->getAddressForm('shipping');
    }

    /**
     * @return \Joomla\CMS\Form\Form
     */
    private function getAddressForm(string $formtype) {
        $form = $this->loadForm("com_eventgallery.{$formtype}address", "{$formtype}address");

        if (!$this->config->getCheckout()->doEnableBusinessCustomerData()) {
            $form->removeField($formtype.'_companyname');
        }

        if ($this->config->getCheckout()->isAddressFieldCountryMandatory()) {
            $form->setFieldAttribute($formtype.'_country','required', 'true');
        }

        if ($this->config->getCheckout()->isAddressFieldStateMandatory()) {
            $form->setFieldAttribute($formtype.'_state','required', 'true');
        }

        if (!$this->config->getCheckout()->doUseAddressFieldState()) {
            $form->removeField($formtype.'_state');
        }

        if (!$this->config->getCheckout()->doUseAddressFieldCountry()) {
            $form->removeField($formtype.'_country');
        }

        return $form;
    }


}

