<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\Model;
use Joomla\CMS\Factory;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\OrderFactory;

defined('_JEXEC') or die();

class OrderModel extends \Joomla\CMS\MVC\Model\BaseDatabaseModel
{
    public function getItem() {

        $app = Factory::getApplication();


        $orderid = $app->input->getString('id', '-1');

        /**
         * @var OrderFactory $orderFactory
         */
        $orderFactory = OrderFactory::getInstance();
        $order = $orderFactory->getOrderById($orderid);

        /**
         * check of the current user is allowed to view this order
         */
        $user = Factory::getUser();
        if ($user->id != $order->getUserId()) {
            return null;
        }

        return $order;
    }

}
