<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\Model;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\OrderFactory;

defined('_JEXEC') or die();

class OrdersModel extends \Joomla\CMS\MVC\Model\ListModel
{

    protected $context = '';


	function __construct($config = [], MVCFactoryInterface $factory = null)
	{
	    parent::__construct($config, $factory);
	}

	/**
	 * Returns the query
	 * @return string The query to be used to retrieve the rows from the database
	 */
	function getListQuery()
	{

        $user = Factory::getUser();

		// Create a new query object.
		$db = $this->getDbo();
		$query = $db->getQuery(true);

		$query->select('*');
		$query->from('#__eventgallery_order');
        $query->where('userid='.$db->quote($user->id));
        if ($user->guest) {
            $query->where('1=2');
        }
		$query->order('created desc');

		return $query;
	}

    function getItems() {
        $items = parent::getItems();
        $result=array();
        /**
         * @var OrderFactory $orderFactory
         */
        $orderFactory = OrderFactory::getInstance();
        foreach($items as $item) {
            $result[] = $orderFactory->getOrderById($item->id);
        }
        return $result;
    }
}
