<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\Model;
use Joomla\CMS\Factory;
use Joomla\CMS\Filter\InputFilter;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Form\FormRule;
use Svenbluege\Component\Eventgallery\Site\Library\Manager\OrderManager;
use Svenbluege\Component\Eventgallery\Site\Library\Order;

defined('_JEXEC') or die();

class TrackorderModel extends \Joomla\CMS\MVC\Model\FormModel
{
    /**
     * Method to get the login form.
     *
     * The base form is loaded from XML and then an event is fired
     * for users plugins to extend the form with extra fields.
     *
     * @param   array  $data        An optional array of data for the form to interogate.
     * @param   boolean $loadData   True if the form is to load its own data (default case), false if not.
     * @return  Form   A Form object on success, false on failure
     * @since   1.6
     */
    public function getForm($data = array(), $loadData = true)
    {
        // Get the form.
        $form = $this->loadForm('com_eventgallery.trackorder', 'trackorder', array('load_data' => $loadData));
        if (empty($form))
        {
            return false;
        }

        return $form;
    }

    public function getLoginForm($data = array(), $loadData = true) {
        return $this->loadForm('com_user.login', JPATH_SITE.'/components/com_users/forms/login.xml', array('load_data' => $loadData));
    }

    public function getItem($orderid = null, $email = null) {

        $app = Factory::getApplication();

        if ($orderid == null) {
            $orderid = $app->input->getString('orderid', '-1');
        }

        if ($email == null) {
            $email = $app->input->getString('email', '-1');
        }
        /**
         * @var OrderManager $orderMgr
         */
        $orderMgr = OrderManager::getInstance();
        $order = $orderMgr->getOrderByDocumentNo($orderid);
        if (null == $order || $order->getEMail()!=$email) {
            return null;
        }

        return $order;
    }

    /**
     * Method to validate the form data.
     *
     * @param   Form   $form   The form to validate against.
     * @param   array   $data   The data to validate.
     * @param   string  $group  The name of the field group to validate.
     *
     * @return  mixed  Array of filtered data if valid, false otherwise.
     *
     * @see     FormRule
     * @see     InputFilter
     * @since   12.2
     */
    public function validate($form, $data, $group = null)
    {

        if (empty($data['orderid']) || empty($data['email'])) {
            return false;
        }

        /**
         * @var Order $order
         */
        $order = $this->getItem($data['orderid'], $data['email']);
        if ($order==null) {
            return false;
        }

        return $data;
    }

}
