<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\View\Cart;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Svenbluege\Component\Eventgallery\Site\Library\Cart;
use Svenbluege\Component\Eventgallery\Site\Library\Common\View;
use Svenbluege\Component\Eventgallery\Site\Library\Manager\CartManager;

defined('_JEXEC') or die;

class HtmlView extends View
{
    /**
     * @var \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main
     */
    protected $config;
    protected $state;

    /**
     * @var Cart
     */
    protected $cart;

    /**
     * @var \Joomla\CMS\Document\HtmlDocument
     */
    public $document;

    function display($tpl = NULL)
    {
        /**
         * @var \Joomla\CMS\Application\CMSApplicationInterface $app
         */
        $app = Factory::getApplication();
        $this->state = $this->get('State');

        $this->config = \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main::getInstance($app->getParams());

        /* @var CartManager $cartMgr */
        $cartMgr = CartManager::getInstance();
        $this->cart = $cartMgr->getCart();


        if ($this->cart->getLineItemsCount() == 0) {
            $this->setLayout("empty");
        }

        $script = Uri::root(true) . '/media/com_eventgallery/dist/eventgallery-cart.js?v=' . EVENTGALLERY_VERSION . '&e=' . EVENTGALLERY_EXTENDED;
        $this->document->addScript($script);
        $style = Uri::root(true) . '/media/com_eventgallery/dist/eventgallery-cart.css?v=' . EVENTGALLERY_VERSION . '&e=' . EVENTGALLERY_EXTENDED;
        $this->document->addStyleSheet($style);

        $pathway = $app->getPathWay();
        $pathway->addItem(\Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_PATH'));

        // show a disabled message once the cart is not active
        if (!$this->config->getCart()->doUseCart()) {
            $this->setLayout('disabled');
        }

        $this->_prepareDocument();

        parent::display($tpl);
    }


    /**
     * Prepares the document
     */
    protected function _prepareDocument()
    {
        $app = Factory::getApplication();
        $title = NULL;

        $title = $this->config->getMenuItem()->getPageTitle();

        $title .= " - " . \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_PATH');


        // Check for empty title and add site name if param is set
        if (empty($title)) {
            $title = $app->get('sitename');
        } elseif ($app->get('sitename_pagetitles', 0) == 1) {
            $title = \Joomla\CMS\Language\Text::sprintf('JPAGETITLE', $app->get('sitename'), $title);
        } elseif ($app->get('sitename_pagetitles', 0) == 2) {
            $title = \Joomla\CMS\Language\Text::sprintf('JPAGETITLE', $title, $app->get('sitename'));
        }


        if ($this->document) {

            $this->document->setTitle($title);

        }
    }

}
