<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\View\Checkout;
use Joomla\CMS\Factory;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Form\FormFactoryInterface;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Svenbluege\Component\Eventgallery\Site\Library\Cart;
use Svenbluege\Component\Eventgallery\Site\Library\Common\View;
use Svenbluege\Component\Eventgallery\Site\Library\Manager\CartManager;
use Svenbluege\Component\Eventgallery\Site\Model\CheckoutModel;

defined('_JEXEC') or die;

class HtmlView extends View
{

    /**
     * @var JDocument
     */
    public $document;

    /**
     * @var \Joomla\CMS\Form\Form
     */
    protected $billingform;
    /**
     * @var Cart
     */
    protected $cart;
    /**
     * @var \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main
     */
    protected $config;

    /**
     * @var \Joomla\CMS\Form\Form
     */
    protected $shippingform;

    /**
     * @var Form
     */
    protected $loginform;

    protected $state;

    /**
     * @var Form
     */
    protected $userdataform;

    /**
     * @var Form
     */
    protected $userdataformwithname;


    function display($tpl = null)
    {
        /**
         * @var \Joomla\CMS\Application\CMSApplicationInterface $app
         */
        $app = Factory::getApplication();
        $this->state = $this->get('State');
        $this->config = \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main::getInstance($app->getParams());
        /**
         * @var CheckoutModel $model
         */
        $model = $this->getModel('checkout');

        /* @var CartManager $cartMgr */
        $cartMgr = CartManager::getInstance();
        $this->cart = $cartMgr->getCart();

        if ($this->cart->getShippingMethod() != null && !$this->cart->getShippingMethod()->needsAddressData()) {
            $skipAddressForms = true;
        } else {
            $skipAddressForms = false;
        }

        // set the default view
        if ($this->getLayout() == 'default') {
            $this->setLayout('review');
        }

        if ($app->input->getBool('returnfrompayment', false)) {
            $app->enqueueMessage(\Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_CONFIRM_PAYMENT_RETURN'));
        }

        // if the current layout is not confirm and some details are missing, display the change page.
        // if there are no items in the cart, go the the cart page.
        if ($this->getLayout() != 'confirm') {

            if ($this->cart->getLineItemsCount()==0) {
                $app->redirect(
                     Route::_("index.php?option=com_eventgallery&view=cart", false)
                );
            }

            if ($this->cart->getShippingMethodServiceLineItem() == null
                || $this->cart->getPaymentMethodServiceLineItem() == null
                || ($this->cart->getShippingAddress() == null && !$skipAddressForms)
                || ($this->cart->getBillingAddress() == null && !$skipAddressForms)
            ) {

                $this->setLayout('change');

            }

        }

        if ($this->getLayout() == 'change') {

            $this->userdataform = $model->getUserDataForm();

            $this->userdataform->reset();
            $this->userdataform->bind(
                array(
                    'message' => $this->cart->getMessage(),
                    'email' => $this->cart->getEMail(),
                    'phone' => $this->cart->getPhone()
                )
            );
            $this->userdataform->bind($app->input->post->getArray());

            $this->userdataformwithname = $model->getUserDataFormWithoutAddress();
            $this->userdataformwithname->reset();
            $this->userdataformwithname->bind(
                array(
                    'firstname' => $this->cart->getFirstname(),
                    'lastname' => $this->cart->getLastname(),
                    'message' => $this->cart->getMessage(),
                    'email' => $this->cart->getEMail(),
                    'phone' => $this->cart->getPhone()
                )
            );
            $this->userdataformwithname->bind($app->input->post->getArray());

            $this->billingform = $model->getBillingAddressForm();

            $this->billingform->reset();

            if ($this->cart->getBillingAddress() != null) {
                $this->billingform->bind($this->cart->getBillingAddress()->_getData('billing_'));
            }
            $this->billingform->bind($app->input->post->getArray());


            $this->shippingform = $model->getShippingAddressForm();


            if ($this->cart->getShippingAddress() != null) {
                $this->shippingform->bind($this->cart->getShippingAddress()->_getData('shipping_'));
            }
            $this->shippingform->bind($app->input->post->getArray());

            $this->loginform = $model->getLoginForm();

            $script = Uri::root(true) . '/media/com_eventgallery/dist/eventgallery-checkout-change.js?v=' . EVENTGALLERY_VERSION . '&e=' . EVENTGALLERY_EXTENDED;
            $this->document->addScript($script);

        }

        $pathway = $app->getPathWay();
        $pathway->addItem(\Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_PATH'));

        $this->_prepareDocument();

        parent::display($tpl);
    }

    /**
     * Prepares the document
     */
    protected function _prepareDocument()
    {
        $app = Factory::getApplication();
        $title = null;

        $title = $this->config->getMenuItem()->getPageTitle();

        $title .= " - " . \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_PATH');


        // Check for empty title and add site name if param is set
        if (empty($title)) {
            $title = $app->get('sitename');
        } elseif ($app->get('sitename_pagetitles', 0) == 1) {
            $title = \Joomla\CMS\Language\Text::sprintf('JPAGETITLE', $app->get('sitename'), $title);
        } elseif ($app->get('sitename_pagetitles', 0) == 2) {
            $title = \Joomla\CMS\Language\Text::sprintf('JPAGETITLE', $title, $app->get('sitename'));
        }


        if ($this->document) {

            $this->document->setTitle($title);

        }
    }

}
