<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\View\Event;
use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Svenbluege\Component\Eventgallery\Site\Library\Common\View;
use Svenbluege\Component\Eventgallery\Site\Library\Database\Localizablestring;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FolderFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Folder\Folder;
use Svenbluege\Component\Eventgallery\Site\Library\Helper\FolderProtection;
use Svenbluege\Component\Eventgallery\Site\Library\Helper\MediaLoader;
use Svenbluege\Component\Eventgallery\Site\Model\EventModel;

defined('_JEXEC') or die;

class HtmlView extends View
{
    /**
     * @var \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main
     */
    protected $config;
    protected $category;
    protected $state;
    protected $pageNav;
    protected $entries;
    protected $entriesCount;
    protected $currentItemid;
    /**
     * @var Folder
     */
    protected $folder;
    /**
     * @var JDocument
     */
    public $document;

    function display($tpl = NULL)
    {

        /**
         * @var \Joomla\CMS\Application\CMSApplicationInterface $app
         */
        $app = Factory::getApplication();
        $this->state = $this->get('State');
        $params = $app->getParams();


        /* Default Page fallback*/
        $active = $app->getMenu()->getActive();
        if (NULL == $active) {
            $params->merge($app->getMenu()->getDefault()->getParams());
            $active = $app->getMenu()->getDefault();
            //just in case the default menu item sets something else.
            $this->setLayout('default');
        }

        $this->config = \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main::getInstance($params);

        $this->currentItemid = $active->id;

        if ($this->getLayout()=='default' && $layout = $this->config->getEventsList()->getEventLayout()) {
            //override the layout with the menu item setting in case we link directly to an event
            if ($active != null && isset($active->query['layout']) && $active->component=='com_eventgallery')  {
                $layout = $active->query['layout'];
            }
            $this->setLayout($layout);
        }

        $this->catid = $app->getInput()->getInt('catid', null);

        if ($this->catid == 0) {
            $this->catid = 'root';
        }

        $categories = \Joomla\CMS\Categories\Categories::getInstance('Eventgallery', []);

        if (null != $this->catid) {
            $this->category = $categories->get($this->catid);
        }

        if ($this->category!=null && $this->category->published!=1) {
            throw new \Exception(\Joomla\CMS\Language\Text::_('JGLOBAL_CATEGORY_NOT_FOUND'), 404);
        }

        // legacy fix since I renamed default to pageable
        if ($this->getLayout()=='default') {
            $this->setLayout('imagelist');
        }

        /**
         * @var EventModel $model
         */
        $model = $this->getModel('event');


        $pageNav = $model->getPagination($app->getInput()->getString('folder', ''), $this->catid);


        if ($this->getLayout() == 'ajaxpaging' || !$this->config->getEventsList()->doEventPaging()) {
            $entries = $model->getEntries($app->getInput()->getString('folder',''), -1, -1);
        } else {
            $entries = $model->getEntries($app->getInput()->getString('folder', ''));
        }

        $titleEntries = $model->getEntries($app->getInput()->getString('folder', ''), -1, -1, true);

        /**
         * @var FolderFactory $folderFactory
         */
        $folderFactory = FolderFactory::getInstance();
        $folder = $folderFactory->getFolder($app->getInput()->getString('folder', ''));

 		if (!is_object($folder) || $folder->isPublished() != 1) {
            throw new \Exception(\Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_EVENT_NO_PUBLISHED_MESSAGE'), 404);
        }

 		if ($this->catid && $this->catid != 'root' && $folder->getCategoryId() != $this->catid) {
 		    if (!$this->config->getCategories()->doShowItemsPerCategoryRecursive()) {
                throw new \Exception(\Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_EVENT_INVALID_CATEGORY_MESSAGE'), 404);
            }

 		    $folderCategory = $categories->get($folder->getCategoryId());
 		    if ($folderCategory == null) {
                throw new \Exception(\Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_EVENT_INVALID_CATEGORY_MESSAGE'), 404);
            }

 		    $path = $folderCategory->getPath();
            if (!isset($path[$this->catid])) {
                throw new \Exception(\Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_EVENT_INVALID_CATEGORY_MESSAGE'), 404);
            }
        }

        if (!$folder->isVisible()) {
            $user = Factory::getUser();
            if ($user->guest) {

                $redirectUrl =  Route::_("index.php?option=com_eventgallery&view=event&folder=" . $folder->getFolderName(), false);
                $redirectUrl = urlencode(base64_encode($redirectUrl));
                $redirectUrl = '&return='.$redirectUrl;
                $joomlaLoginUrl = 'index.php?option=com_users&view=login';
                $finalUrl =  Route::_($joomlaLoginUrl . $redirectUrl, false);
                $app->redirect($finalUrl);
            } else {
                $this->setLayout('noaccess');
            }
        }

        $password = $app->getInput()->getString('password', '');
        $accessAllowed = FolderProtection::isAccessAllowed($folder, $password);

        if (!$accessAllowed) {
            $app->redirect(
                 Route::_("index.php?option=com_eventgallery&view=password&folder=" . $folder->getFolderName(), false)
            );
        }

        // remove the password from the url.
        if (!empty($password)) {
            $app->redirect(
                 Route::_("index.php?option=com_eventgallery&view=event&folder=" . $folder->getFolderName(), false)
            );
        }

        if( ($this->config->getEventsList()->doShuffleImages() || $folder->doShuffleImages())
        	&& !$this->config->getEventsList()->doEventPaging()) {
            $allowedLayouts = Array(
                    'ajaxpaging',
                    'imagelist',
                    'simple',
                    'tiles'
                );
            if (in_array($this->getLayout(), $allowedLayouts)) {
                shuffle($entries);
            }
        }

        $folder->countHits();

        $this->pageNav = $pageNav;
        $this->entries = $entries;
        $this->entriesCount = count($entries);
        $this->titleEntries = $titleEntries;

        $this->folder = $folder;

        /**
         * @var JPathway $pathway
         */
        $pathway = $app->getPathway();

        // add the category but avoid adding a category which is defined in the menu item
        if ($active->query['view']=='categories' && (isset($active->query['catid']) && $active->query['catid'] != $folder->getCategoryId()) ) {
            $rootCategoryId = 0;
            $skipRoot = false;
            if ( isset($active->query['catid']) ) {
                $rootCategoryId = $active->query['catid'];
                $skipRoot = true;
            }
            \Svenbluege\Component\Eventgallery\Site\Helper\CategoriesHelper::addCategoryPathToPathway($pathway, $rootCategoryId, $folder->getCategoryId(), $this->currentItemid, $skipRoot);
        }

        // add the event
        $pathway->addItem($folder->getDisplayName());

        $this->_prepareDocument();
        $this->addOpenGraphTags($this->folder, $this->document, $this->config);

        MediaLoader::loadMedia($this->config);

        parent::display($tpl);
    }

    /**
     * @param $folder Folder
     * @param $document JDocument
     * @param $config \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main
     */
    protected function addOpenGraphTags($folder, $document, $config) {
        $document->setMetaData("og:title", strip_tags ($folder->getDisplayName()), "property");
        $document->setMetaData("og:description", strip_tags ($folder->getText()), "property");


        if (!$config->getSocial()->doUseSocialSharingButton()) {
            return;
        }

        $files = $folder->getFiles(0,1,1);
        if (count($files)>0) {
            $file = $files[0];
            $document->setMetaData("og:image", $file->getSharingImageUrl(), "property");
            $document->setMetaData("og:type", "website", "property");
      }

    }
    /**
     * Prepares the document
     */
    protected function _prepareDocument()
    {
        $app    = Factory::getApplication();
        $menus  = $app->getMenu();
        $menu = $menus->getActive();
        $title = null;

        // Because the application sets a default page title,
        // we need to get it from the menu item itself
        if ($menu)
        {
            $this->config->set('page_heading', $this->config->getMenuItem()->getPageTitle());
        }

        $title = $this->config->getMenuItem()->getPageTitle();

        // checks for empty title or sets the folder description if
        // the current menu item is not the event view. This avoids
        // having the title of them menu item on all sub events
        if ( empty($title) ||
            (isset($menu->query['view']) && strcmp($menu->query['view'],'event')!=0)
           ) {
            $title = $this->folder->getDisplayName();
        }

        // Check for empty title and add site name if param is set
        if (empty($title)) {
            $title = $app->get('sitename');
        }
        elseif ($app->get('sitename_pagetitles', 0) == 1) {
            $title = \Joomla\CMS\Language\Text::sprintf('JPAGETITLE', $app->get('sitename'), $title);
        }
        elseif ($app->get('sitename_pagetitles', 0) == 2) {
            $title = \Joomla\CMS\Language\Text::sprintf('JPAGETITLE', $title, $app->get('sitename'));
        }
        if (empty($title)) {
            $title = $this->folder->getDisplayName();
        }
        $this->document->setTitle($title);


        $description = $title = $this->config->getMenuItem()->getMetaDescription();

        if (empty($description) || ( isset($menu->query['view']) && strcmp($menu->query['view'],'event')!=0)) {
            $localizedFolderMetaDescription = new Localizablestring($this->folder->getMetadata()->get('metadesc'));
            $description = $localizedFolderMetaDescription->get();

            // set the text of the folder as description if the meta desc is not set
            // or the menu item does not link to a single event
            if (empty($description)) {
                $description = strip_tags($this->folder->getText());
            }
        }

        $this->document->setDescription($description);

        $localizedFolderMetaKeys = new Localizablestring($this->folder->getMetadata()->get('metakey'));
        $keys = $localizedFolderMetaKeys->get();

        if ($this->config->getMenuItem()->getMetaKeywords())
        {
            $keys = $this->config->getMenuItem()->getPageTitle();
        }

        $this->document->setMetaData('keywords', $keys);

        if ($this->config->getMenuItem()->getRobots())
        {
            $this->document->setMetaData('robots', $this->config->getMenuItem()->getRobots());
        }
    }
}


