<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\View\Password;
use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Svenbluege\Component\Eventgallery\Site\Library\Common\View;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FolderFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Folder\Folder;

defined('_JEXEC') or die;

class HtmlView extends View
{
    /**
     * @var \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main
     */
    protected $config;
    protected $state;

    /**
     * @var \Svenbluege\Component\Eventgallery\Site\Library\File\File
     */
    protected $file;

    /**
     * @var Folder
     */
    protected $folder;
    protected $formaction;

    /**
     * @var JDocument
     */
    public $document;


    function display($tpl = NULL)
    {
        /**
         * @var \Joomla\CMS\Application\CMSApplicationInterface $app
         */
        $app = Factory::getApplication();
        $this->state = $this->get('State');
        $this->config = \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main::getInstance($app->getParams());

        $file = $app->input->getString('file', '');
        $folder = $app->input->getString('folder', '');

        /**
         * @var FolderFactory $folderFactory
         */
        $folderFactory = FolderFactory::getInstance();
        $folder = $folderFactory->getFolder($folder);

        if (!is_object($folder)) {
            $app->redirect(Route::_("index.php?", false));
        }

        $formAction =  Route::_("index.php?option=com_eventgallery&view=event&folder=" . $folder->getFolderName());

        $this->folder = $folder;
        $this->file = $file;
        $this->formaction = $formAction;

        $this->_prepareDocument();

        parent::display($tpl);
    }

    /**
     * Prepares the document
     */
    protected function _prepareDocument()
    {
        $app = Factory::getApplication();
        $menus = $app->getMenu();

        $title = NULL;

        // Because the application sets a default page title,
        // we need to get it from the menu item itself
        $menu = $menus->getActive();
        if ($menu) {
            $this->config->set('page_heading', $this->config->getMenuItem()->getPageTitle());
        }


        $title = $this->config->getMenuItem()->getPageTitle();

        if ($this->folder->getDisplayName()) {
            $title = $this->folder->getDisplayName();
        }


        // Check for empty title and add site name if param is set
        if (empty($title)) {
            $title = $app->get('sitename');
        } elseif ($app->get('sitename_pagetitles', 0) == 1) {
            $title = \Joomla\CMS\Language\Text::sprintf('JPAGETITLE', $app->get('sitename'), $title);
        } elseif ($app->get('sitename_pagetitles', 0) == 2) {
            $title = \Joomla\CMS\Language\Text::sprintf('JPAGETITLE', $title, $app->get('sitename'));
        }
        if (empty($title)) {
            $title = $this->folder->getDisplayName();
        }
        $this->document->setTitle($title);

        if ($this->folder->getText()) {
            $this->document->setDescription($this->folder->getText());
        } elseif (!$this->folder->getText() && $this->config->getMenuItem()->getMetaDescription()) {
            $this->document->setDescription($this->config->getMenuItem()->getMetaDescription());
        }
    }
}


