<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\View\Singleimage;
use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Svenbluege\Component\Eventgallery\Site\Library\Common\View;
use Svenbluege\Component\Eventgallery\Site\Library\Database\Localizablestring;
use Svenbluege\Component\Eventgallery\Site\Library\Folder\Folder;
use Svenbluege\Component\Eventgallery\Site\Library\Helper\FolderProtection;
use Svenbluege\Component\Eventgallery\Site\Library\Helper\MediaLoader;
defined('_JEXEC') or die;

class HtmlView extends View
{
    /**
     * @var \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main
     */
    public $config;
    public $state;
    public $currentItemid;
    public $messageForm;
    /**
     * @var Folder
     */
    public $folder;

    /**
     * @var \Svenbluege\Component\Eventgallery\Site\Library\File\File
     */
    public $file;

    public $position;
    public $model;
    /**
     * @var JDocument
     */
    public $document;


    function display($tpl = NULL)
    {
        /**
         * @var \Joomla\CMS\Application\CMSApplicationInterface $app
         */
        $app = Factory::getApplication();

        $this->state = $this->get('State');
        $params = $app->getParams();


        $this->catid = $app->input->getInt('catid', null);
        if ($this->catid == 0) {
            $this->catid = 'root';
        }

        $options = array();

        $categories = \Joomla\CMS\Categories\Categories::getInstance('Eventgallery', $options);

        /**
         * @var JCategoryNode $root
         */

        if (null != $this->catid) {
            $this->category = $categories->get($this->catid);
        }

        if ($this->category!=null && $this->category->published!=1) {
            throw new \Exception(\Joomla\CMS\Language\Text::_('JGLOBAL_CATEGORY_NOT_FOUND'), 404);
        }


        $model = $this->getModel('singleimage');
        $model->getData($app->input->getString('folder'), $app->input->getString('file'));

        $this->model = $model;
        $this->file = $model->file;

        if (!is_object($this->file) || $this->file->isPublished() != 1) {
            throw new \Exception(\Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_SINGLEIMAGE_NO_PUBLISHED_MESSAGE'), 404);
        }

        $this->folder = $this->file->getFolder();
        $this->position = $model->position;

        /** Default Page fallback
         * @var JMenu $active
        */
        $active = $app->getMenu()->getActive();
        if (NULL == $active) {
            $params->merge($app->getMenu()->getDefault()->getParams());
            $active = $app->getMenu()->getDefault();
        }
        $this->config = \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main::getInstance($params);

        $this->currentItemid = $active->id;

        if (!is_object($this->folder) || $this->folder->isPublished() != 1) {
            throw new \Exception(\Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_EVENT_NO_PUBLISHED_MESSAGE'), 404);
        }


        if (!isset($this->file) || empty($this->file->getFileName()) || $this->file->isPublished() != 1) {
            throw new \Exception(\Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_SINGLEIMAGE_NO_PUBLISHED_MESSAGE'), 404);
        }

        if (!$this->folder->isVisible()) {
            $user = Factory::getUser();
            if ($user->guest) {

                $redirectUrl =  Route::_("index.php?option=com_eventgallery&view=singleimage&folder=" . $this->folder->getFolderName()."&file=".$this->file->getFileName().'&Itemid='. $this->currentItemid, false);
                $redirectUrl = urlencode(base64_encode($redirectUrl));
                $redirectUrl = '&return='.$redirectUrl;
                $joomlaLoginUrl = 'index.php?option=com_users&view=login';
                $finalUrl =  Route::_($joomlaLoginUrl . $redirectUrl, false);
                $app->redirect($finalUrl);
            } else {
                $this->setLayout('noaccess');
            }
        }

        $password = $app->input->getString('password', '');
        $accessAllowed = FolderProtection::isAccessAllowed($this->folder, $password);
        if (!$accessAllowed) {
            $app->redirect(
                 Route::_("index.php?option=com_eventgallery&view=password&folder=" . $this->folder->getFolderName().'&Itemid='. $this->currentItemid, false)
            );
        }

        // remove the password from the url
        if (!empty($password)) {
            $app->redirect(
                 Route::_("index.php?option=com_eventgallery&view=singleimage&folder=" . $this->folder->getFolderName()."&file=".$this->file->getFileName().'&Itemid='. $this->currentItemid, false)
            );
        }

        $pathway = $app->getPathWay();

        if ($active->query['view']=='categories') {
            \Svenbluege\Component\Eventgallery\Site\Helper\CategoriesHelper::addCategoryPathToPathway($pathway, $app->input->getInt('catid', 0), $this->folder->getCategoryId(), $this->currentItemid);
        }

        $pathway->addItem(
            $this->folder->getDisplayName(),  Route::_('index.php?option=com_eventgallery&view=event&folder=' . $this->folder->getFolderName() .'&Itemid='. $this->currentItemid)
        );
        $pathway->addItem($model->position . ' / ' . $model->overallcount);

        if ($this->document->getType() == 'raw') {
            $this->setLayout($app->input->getString('layout','minipage'));
        } else {
            $this->_prepareDocument();
            $this->addOpenGraphTags($this->folder, $this->file, $this->document, $this->config);

            MediaLoader::loadMedia($this->config);
        }

        if ($this->getLayout() == 'report') {
            $this->messageForm = $model->getMessageForm();
            $this->messageForm->bind($app->input->post->getArray());
        }

        parent::display($tpl);
    }

    /**
     * @param $folder Folder
     * @param $file \Svenbluege\Component\Eventgallery\Site\Library\File\File
     * @param $document JDocument
     * @param $config \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main
     */
    protected function addOpenGraphTags($folder, $file, $document, $config) {
        $titles = [];
        if (!empty($folder->getDisplayName())) {
            $titles[] = $folder->getDisplayName();
        } else {
            $titles[] = $file->getFolderName();
        }


        if (!empty($file->getTitle($this->config->getEvent()->doShowImageFilename(), $this->config->getEvent()->doShowExif(), $this->config->getEvent()->doShowImageTitle(), $this->config->getEvent()->doShowImageCaption()))) {
            $titles[] = $file->getPlainTextTitle($this->config->getEvent()->doShowImageTitle(), $this->config->getEvent()->doShowImageCaption());
        } else {
            $titles[] = $file->getFileName();
        }

        $titles = array_filter($titles, function($value) { return !empty($value); });
        $title = implode(" - ", $titles);

        $description = $file->getFileCaption();
        if (empty($description)) {
            $description = $folder->getText();
        }


        $document->setMetaData("og:title", strip_tags ($title), "property");
        $document->setMetaData("og:description", strip_tags ($description), "property");


        if (!$config->getSocial()->doUseSocialSharingButton()) {
            return;
        }

        $document->setMetaData("og:image", $file->getSharingImageUrl(), "property");
        $document->setMetaData("og:type", "website", "property");

    }

    /**
     * Prepares the document
     */
    protected function _prepareDocument()
    {
        $app    = Factory::getApplication();
        $menus  = $app->getMenu();
        $title = null;

        // Because the application sets a default page title,
        // we need to get it from the menu item itself
        $menu = $menus->getActive();
        if ($menu)
        {
            $this->config->set('page_heading', $this->config->getMenuItem()->getPageTitle());
        }

        $titleParts = [];
        $pageTitle = trim($this->config->getMenuItem()->getPageTitle());
        if (!empty($pageTitle)) {
            $titleParts[] = $pageTitle;
        }
        $titleParts[] = $this->file->getAltContent($this->config->getEvent()->doShowImageTitle(), $this->config->getEvent()->doShowImageCaption());

        $title = implode(' - ', $titleParts);

        // Check for empty title and add site name if param is set
        if (empty($title)) {
            $title = $app->get('sitename');
        }
        elseif ($app->get('sitename_pagetitles', 0) == 1) {
            $title = \Joomla\CMS\Language\Text::sprintf('JPAGETITLE', $app->get('sitename'), $title);
        }
        elseif ($app->get('sitename_pagetitles', 0) == 2) {
            $title = \Joomla\CMS\Language\Text::sprintf('JPAGETITLE', $title, $app->get('sitename'));
        }

        if ($this->document) {
            $localizedFolderMetaDescription = new Localizablestring($this->folder->getMetadata()->get('metadesc'));
            $description = $localizedFolderMetaDescription->get();

            if (!empty($description)) {
                $this->document->setDescription($description);
            }
            elseif ($this->folder->getText())
            {
                $this->document->setDescription(strip_tags($this->folder->getText()));
            }
            elseif (!$this->folder->getText() && $this->config->getMenuItem()->getMetaDescription())
            {
                $this->document->setDescription($this->config->getMenuItem()->getMetaDescription());
            }

            if ($this->config->getMenuItem()->getMetaKeywords())
            {
                $this->document->setMetaData('keywords', $this->config->getMenuItem()->getMetaKeywords());
            } else {
                $localizedFolderMetaKeys = new Localizablestring($this->folder->getMetadata()->get('metakey'));
                $this->document->setMetaData('keywords', $localizedFolderMetaKeys->get());
            }

            if ($this->config->getMenuItem()->getRobots())
            {
                $this->document->setMetaData('robots', $this->config->getMenuItem()->getRobots());
            }

            $this->document->setTitle($title);
        }
    }

}
