<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Site\View\Upload;
use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Svenbluege\Component\Eventgallery\Administrator\Helper\Backendmedialoader;
use Svenbluege\Component\Eventgallery\Site\Library\Common\View;
defined('_JEXEC') or die;

class HtmlView extends View
{
    /**
     * @var \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main
     */
    protected $config;
    protected $folder;
    protected $returnUrl;

    /**
     * @var JDocument
     */
    public $document;

    function display($tpl = NULL)
    {

        Backendmedialoader::load();

        /**
         * @var \Joomla\CMS\Application\CMSApplicationInterface $app
         */
        $app = Factory::getApplication();
        $this->returnUrl = base64_decode($app->input->getString('return')?:'');

        $this->folder = $this->get('Item');
        $this->config = \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main::getInstance($app->getParams());

        $user = Factory::getUser();

        $canUpload = $user->authorise('core.edit', "com_eventgallery");
        if (!$canUpload) {
            $app->enqueueMessage(\Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_EVENT_UPLOAD_NO_PERMISSION'), 'error');
            $app->redirect( Route::_('index.php?view=events'));
        }

        parent::display($tpl);
    }

}
