<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Svenbluege\Component\Eventgallery\Site\Library\ImageLineitem;
use Svenbluege\Component\Eventgallery\Site\Library\ImageType;
defined('_JEXEC') or die('Restricted access');

/**
 * @var \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main $config;
 */
$config = $this->config;

?>


<div class="eventgallery-cart">
    <h1><?php echo Text::_('COM_EVENTGALLERY_CART_CHECKOUT_ITEMS_IN_YOUR_CART') ?></h1>
    <?php echo Text::_('COM_EVENTGALLERY_CART_TEXT') ?>

    <form action="<?php echo  Route::_("index.php?option=com_eventgallery&view=cart&task=updateCart") ?>" method="post"
          class="form-validate form-horizontal cart-form">
        <div class="card">
            <div class="card-body">
                <div class="cart-items">

                        <?php foreach ($this->cart->getLineItems() as $lineitem) :
                            /** @var ImageLineitem $lineitem */ ?>


                                    <div class="lineitem-container" id="row_<?php echo $lineitem->getId() ?>">
                                        <div class="image">
                                            <?php echo $lineitem->getCartThumb(); ?>
                                        </div>


                                        <div class="information">
                                            <input class="validate-numeric required input-mini eventgallery-quantity form-control" type="number" title="<?php echo Text::_('COM_EVENTGALLERY_LINEITEM_QUANTITY')?>" min="0"
                                                   <?php echo $lineitem->getImageType()->getMaxOrderQuantity()==0?"":'max="'.$lineitem->getImageType()->getMaxOrderQuantity().'""'; ?>
                                                   name="quantity_<?php echo $lineitem->getId() ?>"
                                                   value="<?php echo $lineitem->getQuantity() ?>"/>
                                            <?php
                                            $imageTypes = $lineitem->getFile()->getImageTypeSet()->getImageTypes(true);
                                            if (count($imageTypes)>1) {
                                                ?>
                                                <select title="<?php echo Text::_('COM_EVENTGALLERY_LINEITEM_IMAGETYPE')?>" class="required imagetype form-control" name="type_<?php echo $lineitem->getId() ?>">
                                                <?php
                                                        foreach ($imageTypes as $imageType) {
                                                            /** @var ImageType $imageType */
                                                            $selected = $lineitem->getImageType()->getId() == $imageType->getId()
                                                                ? 'selected="selected"' : '';
                                                            echo '<option ' . $selected . ' value="' . $imageType->getId() . '">'
                                                                . Text::sprintf('COM_EVENTGALLERY_LINEITEM_PRICE_PER_ITEM_DROPDOWM', $imageType->getDisplayName(), $imageType->getPrice() )
                                                                . '</option>';
                                                        }
                                                ?>

                                                </select>
                                                <?php
                                                }
                                                else {
                                                    $imageType = array_values($imageTypes)[0];
                                                    echo Text::sprintf('COM_EVENTGALLERY_LINEITEM_PRICE_PER_ITEM_DROPDOWM', $imageType->getDisplayName(), $imageType->getPrice() );
                                                }
                                                ?>
                                            <?php $this->lineitem = $lineitem; echo $this->loadSnippet('/checkout/image_details'); ?>
                                            <div class="imagetype-details eventgallery-hide-on-imagetype-change">
                                                <span class="description"><?php echo $lineitem->getImageType()->getDescription() ?></span>
                                                <?php IF( count($lineitem->getImageType()->getScalePrices()) == 0):?>
                                                    <span class="singleprice">
                                                        <?php echo Text::sprintf('COM_EVENTGALLERY_LINEITEM_PRICE_PER_ITEM_WITH_PLACEHOLDER', $lineitem->getImageType()->getPrice()) ?>
                                                    </span>
                                                <?php ELSE: ?>
                                                    <p><?php echo Text::sprintf('COM_EVENTGALLERY_LINEITEM_PRICE_SCALEPRICEINFORMATION_LABEL'); ?>
                                                    <a href="#" class="scalepriceinformation"><?php echo Text::sprintf('COM_EVENTGALLERY_LINEITEM_PRICE_SCALEPRICEINFORMATION_LINK'); ?></a>
                                                    </p>
                                                    <div style="display: none;" class="scaleprices">
                                                        <?php $this->showstar=false; $this->imagetype = $lineitem->getImageType(); echo $this->loadSnippet('imageset/scaleprice/default');?>
                                                    </div>
                                                <?php ENDIF; ?>

                                                <?php IF($lineitem->getImageType()->getFlatPrice()->getAmount()>0): ?>
                                                    <p>
                                                        <?php echo Text::sprintf('COM_EVENTGALLERY_LINEITEM_FLATPRICE_WITH_PLACEHOLDER', $lineitem->getImageType()->getFlatPrice()) ?>
                                                    </p>
                                                <?php ENDIF; ?>

                                            </div>


                                            <p class="lineitem-actions">
                                                <a class="open-event" href="<?php echo  Route::_(\Svenbluege\Component\Eventgallery\Site\Library\Helper\Route::createEventRoute($lineitem->getFile()->getFolder()->getFolderName(), $lineitem->getFile()->getFolder()->getTags(), $lineitem->getFile()->getFolder()->getCategoryId())) ?>"><small><i class="egfa egfa-list-ul"></i> <?php echo Text::_('COM_EVENTGALLERY_LINEITEM_OPEN_EVENT')?></small></a>
                                                <a class="clone" href="<?php echo  Route::_(
                                                    "index.php?option=com_eventgallery&view=cart&task=cloneLineItem&lineitemid="
                                                    . $lineitem->getId()
                                                ); ?>"><small><i class="egfa egfa-copy"></i> <?php echo Text::_('COM_EVENTGALLERY_LINEITEM_CLONE') ?></small></a>
                                                <a class="delete delete-lineitem" data-lineitemid="<?php echo $lineitem->getId() ?>"
                                                   href="#"><small><i class="egfa egfa-remove"></i> <?php echo Text::_('COM_EVENTGALLERY_LINEITEM_DELETE') ?></small></a>
                                                <a class="add-comment" href="#"><small><i class="egfa egfa-comment"></i> <?php echo Text::_('COM_EVENTGALLERY_LINEITEM_ADD_COMMENT')?></small></a>
                                            </p>

                                            <p class="lineitem-comment <?php if (empty($lineitem->getBuyerNote())) echo "lineitem-comment-hidden" ?>">
                                                <textarea class="form-control" name="comment_<?php echo $lineitem->getId() ?>" rows="2"><?php echo $this->escape($lineitem->getBuyerNote()); ?></textarea>
                                            </p>

                                        </div>
                                        <div class="price eventgallery-hide-on-quantity-change">
                                            <input class="form-control-plaintext" type="text" disabled="disabled" value="<?php echo $lineitem->isPriceIncluded()? Text::_("COM_EVENTGALLERY_LINEITEM_PRICE_INCLUDED") : $lineitem->getPrice(); ?>">
                                        </div>


                                    </div>
                        <?php endforeach ?>
                </div>
            </div>
        </div>

<div class="card">
    <div class="card-body">
        <?php $this->set('edit',false); $this->set('lineitemcontainer', $this->cart); echo $this->loadSnippet('order/total') ?>
        <div class="needs-calculation" style="display: none;">
            <?php echo Text::_('COM_EVENTGALLERY_CART_RECALCULATE') ?>
        </div>
    </div>

</div>




        <fieldset>
            <div class="eg-form-actions">
                <div class="left">
                    <a href="#" class="validate btn btn-warning eventgallery-removeAll"
                    ><?php echo Text::_('COM_EVENTGALLERY_CART_FORM_REMOVE_ALL') ?></a>
                </div>
                <div class="right">
                    <div class="btn-group">
                        <input name="updateCart" type="submit" class="validate btn btn-secondary eventgallery-update"
                               value="<?php echo Text::_('COM_EVENTGALLERY_CART_FORM_UPDATE') ?>"/>
                        <input name="continue" type="submit" class="validate btn btn-primary"
                               value="<?php echo Text::_('COM_EVENTGALLERY_CART_FORM_CONTINUE') ?>"/>
                    </div>
                </div>
            </div>
        </fieldset>
        <?php echo \Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
    </form>
</div>

<?php echo $this->loadSnippet('footer_disclaimer'); ?>
