<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;

defined('_JEXEC') or die('Restricted access');

?>

<div class="eventgallery-checkout eventgallery-change-page">
    <h1><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_CHANGE_HEADLINE') ?></h1>
    <p>
        <?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_CHANGE_TEXT') ?>&nbsp;

        <?php IF (Factory::getUser()->guest): ?>

        <?php ELSE: ?>
            <?php echo \Joomla\CMS\Language\Text::sprintf('COM_EVENTGALLERY_CHECKOUT_LOGGEDIN_LABEL', Factory::getUser()->name, Factory::getUser()->username);?>
            <a href="<?php echo  Route::_('index.php?option=com_users&view=login')?>"><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CHECKOUT_LOGMEOUT'); ?></a>
        <?php ENDIF ?>
    </p>
    <?php echo $this->loadTemplate('login'); ?>

    <form action="<?php echo  Route::_("index.php?option=com_eventgallery&view=checkout&task=saveChanges") ?>"
          method="post" class="form-validate form-horizontal checkout-form"
          id="checkout-form"
    >

        <?php echo $this->loadTemplate('payment'); ?>
        <?php echo $this->loadTemplate('shipping'); ?>
        <?php echo $this->loadTemplate('address'); ?>

        <fieldset>
            <div class="eg-form-actions">
                <div class="right">
                    <input type="submit" class="validate btn btn-primary"
                           value="<?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_CHANGE_FORM_CONTINUE') ?>"/>
                </div>
            </div>
        </fieldset>
        <input name="continue" value="continue" type="hidden">
        <?php echo \Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
    </form>

</div>

<?php echo $this->loadSnippet('footer_disclaimer'); ?>
