<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die('Restricted access');

?>
<div class="card">
    <div class="card-header"><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CHECKOUT_ADDRESS_SECTION_LABEL');?></div>
    <div class="eventgallery-checkout-address eventgallery-checkout-form-without-address">
        <div class="card-body">
            <fieldset class="userdata-fieldset">
                <?php foreach ($this->userdataformwithname->getFieldset() as $field): ?>
                    <div class="control-group form-group row">
                        <?php if (!$field->hidden): ?>
                            <?php echo $field->label; ?>
                        <?php endif; ?>
                        <div class="controls col-sm-9"><?php echo $field->input; ?></div>
                    </div>
                <?php endforeach; ?>
            </fieldset>
        </div>
    </div>


    <div class="eventgallery-checkout-address eventgallery-checkout-form-with-address">
        <div class="card-body">
            <fieldset class="userdata-fieldset">
                <?php foreach ($this->userdataform->getFieldset() as $field): ?>
                    <div class="control-group form-group row">
                        <?php if (!$field->hidden): ?>
                            <?php echo $field->label; ?>
                        <?php endif; ?>
                        <div class="controls col-sm-9">
                            <?php echo $field->input; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </fieldset>
        </div>


        <div class="card-body" id="address-input-area">
            <fieldset class="billing-address-fieldset">
                <?php foreach ($this->billingform->getFieldset() as $field): ?>
                    <div class="control-group form-group row">
                        <?php if (!$field->hidden): ?>
                            <?php echo $field->label; ?>
                        <?php endif; ?>
                        <div class="controls col-sm-9">
                            <?php echo $field->input; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </fieldset>

            <fieldset class="ship-to_different-address-fieldset">
                <div class="control-group form-group">
                    <?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_FORM_SHIPTODIFFERENTADDRESS') ?>
                    <?php
                    $checkF = '';
                    $checkT = '';
                    if ($this->cart->getShippingAddress() == NULL
                        || $this->cart->getBillingAddress() == NULL
                        || $this->cart->getShippingAddress()->getId() == $this->cart->getBillingAddress()->getId()
                    ) {
                        $checkF = ' checked="checked" ';
                    } else {
                        $checkT = ' checked="checked" ';
                    }
                    ?>
                    <div class="controls row">
                        <div class="col-form-label col-sm-3 pt-0"></div>
                        <div class="col-sm-9">
                            <div class="form-check">
                                <input title="<?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_FORM_SHIPTODIFFERENTADDRESS_FALSE')?>" autocomplete="off" type="radio" id="shiptodifferentaddress-false" name="shiptodifferentaddress"
                                   class="pull-left form-check-input" value="false" <?php echo $checkF; ?>>
                                <label class="form-check-label checkbox" for="shiptodifferentaddress-false"><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_FORM_SHIPTODIFFERENTADDRESS_FALSE') ?></label>
                            </div>
                            <div class="form-check">

                                <input title="<?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_FORM_SHIPTODIFFERENTADDRESS_TRUE')?>" autocomplete="off" type="radio" id="shiptodifferentaddress-true" name="shiptodifferentaddress"
                                   class="shiptodifferentaddress pull-left form-check-input"value="true" <?php echo $checkT; ?>>
                                <label class="form-check-label checkbox" for="shiptodifferentaddress-true"><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_FORM_SHIPTODIFFERENTADDRESS_TRUE') ?></label>
                            </div>
                        </div>
                    </div>
                </div>
            </fieldset>

            <fieldset class="shipping-address-fieldset">
                <?php foreach ($this->shippingform->getFieldset() as $field): ?>
                    <div class="control-group form-group row">
                        <?php if (!$field->hidden): ?>
                            <?php echo $field->label; ?>
                        <?php endif; ?>
                        <div class="controls col-sm-9">
                            <?php echo $field->input; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </fieldset>

        </div>

    </div>
</div>
