<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;

defined('_JEXEC') or die;

/**
 * @var \de\svenbluege\joomla\eventgallery\ObjectWithConfiguration $this
 */
$showLoginForm = $this->config->getCheckout()->doUseLoginForm();

?>

<?php IF ($showLoginForm && Factory::getUser()->guest): ?>


    <div class="card">
    <div class="card-header">
        <?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CHECKOUT_FORM_REGISTERED_LABEL');?>
    </div>
        <div class="card-body">
            <p><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CHECKOUT_FORM_REGISTERED_DESC');?></p>
            <?php
                $app = Factory::getApplication();
                $itemid = $app->getMenu()->getActive()->id;
                $loginUrl = "index.php?option=com_eventgallery&view=checkout&layout=change&Itemid=$itemid";
                $loginUrl = urlencode(base64_encode($loginUrl));
                $loginUrl = '&return='.$loginUrl;
                $joomlaLoginUrl = 'index.php?option=com_users&view=login';
                $finalUrl =  Route::_($joomlaLoginUrl . $loginUrl, false);
            ?>
            <a href="<?php echo $finalUrl?>" class="button-login btn btn-primary"><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CHECKOUT_FORM_LOGIN_BUTTON_LABEL')?></a>

            <?php IF (\Joomla\CMS\Component\ComponentHelper::getParams('com_users')->get('allowUserRegistration') == 1): ?>
                <?php
                    $app = Factory::getApplication();
                    $itemid = $app->getMenu()->getActive()->id;
                    $loginUrl = "index.php?option=com_eventgallery&view=checkout&layout=change&Itemid=$itemid";
                    $loginUrl = urlencode(base64_encode($loginUrl));
                    $loginUrl = '&return='.$loginUrl;
                    $joomlaLoginUrl =  Route::_('index.php?option=com_users&view=registration');
                    $finalUrl =  Route::_($joomlaLoginUrl . $loginUrl, false);
                ?>
                <a href="<?php echo $finalUrl?>" class="button-register btn btn-secondary"><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CHECKOUT_FORM_REGISTER_BUTTON_LABEL')?></a>
            <?php ENDIF; ?>
        </div>
    </div>


<?php ENDIF ?>
