<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Svenbluege\Component\Eventgallery\Site\Library\Factory\PaymentMethodFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Methods\PaymentMethod;

defined('_JEXEC') or die('Restricted access');

/**
 * @var PaymentMethodFactory $paymentMethodFactory
 */

$paymentMethodFactory = PaymentMethodFactory::getInstance();
$methods = $paymentMethodFactory->getMethods(true);
$currentMethod
    = $this->cart->getPaymentMethod() == NULL ? $paymentMethodFactory->getDefaultMethod()
    : $this->cart->getPaymentMethod();


?>

<style>

    .payment-body,
    .shipping-body {
       display: none;
    }

    .payment-body-selected,
    .shipping-body-selected{
        display: block;
    }

</style>

<div class="card">

    <div class="card-header" for="paymentid"><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_FORM_PAYMENTMETHOD_LABEL') ?></div>
    <div class="card-body">

        <?php IF(count($methods) == 0):?>
            <?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_NO_PAYMENTMETHODS_CONFIGURED')?>
        <?php ENDIF ?>

            <?php FOREACH ($methods as $method): ?>
                <?php

                /**
                 * @var PaymentMethod $method
                 */
                $selected = "";
                $cssSelected = "";

                if ($method->getId() == $currentMethod->getId()) {
                    $selected = 'checked = "checked"';
                    $cssSelected = 'payment-body-selected';
                }

                $disabled = "";

                if ($method->isEligible($this->cart)==false ) {
                    continue;
                }

                $paymentBodyContent = $method->getPaymentPageContentBody($this->cart);

                ?>
                <div class="payment-container">
                    <div class="payment-head">
                        <label class="radio">
                            <input  <?php echo $selected; ?> <?php echo $disabled; ?> type="radio" class="" name="paymentid" id="paymentid<?php echo $method->getId(); ?>" value="<?php echo $method->getId(); ?>">
                            <span><?php echo $method->getPaymentPageContentHead($this->cart); ?></span>
                            <?php $price = $method->getPrice($this->cart); if ($price->getAmount()>0) { echo "(" . $price . ")"; } ?>
                        </label>
                    </div>
                    <?php IF(!empty($paymentBodyContent)): ?>
                        <div class="payment-body <?php echo $cssSelected?>"><?php echo $paymentBodyContent ?></div>
                    <?php ENDIF;  ?>
                </div>
            <?php ENDFOREACH ?>

    </div>
</div>


