<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Svenbluege\Component\Eventgallery\Site\Library\Factory\ShippingMethodFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Methods\ShippingMethod;

defined('_JEXEC') or die('Restricted access');
/**
 * @var ShippingMethodFactory $shippingMethodFactory
 */

$shippingMethodFactory = ShippingMethodFactory::getInstance();

$methods = $shippingMethodFactory->getMethods(true);
$currentMethod
    = $this->cart->getShippingMethod() == NULL ? $shippingMethodFactory->getDefaultMethod()
    : $this->cart->getShippingMethod();
?>

<div class="card">
    <div class="card-header" for="shippingid"><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_FORM_SHIPPINGMETHOD_LABEL') ?></div>
    <div class="card-body">
        <?php IF(count($methods) == 0):?>
            <?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_NO_SHIPPINGMETHODS_CONFIGURED')?>
        <?php ENDIF ?>
        <?php FOREACH ($methods as $method): ?>


        <?php

        /**
        * @var ShippingMethod $method
        */
        $selected = "";
        $cssSelected = "";

        if ($method->getId() == $currentMethod->getId()) {
            $selected = 'checked = "checked"';
            $cssSelected = 'shipping-body-selected';
        }

        $disabled = "";

        if ($method->isEligible($this->cart)==false ) {
            continue;
        }

        $shippingBodyContent = $method->getDescription();

        ?>
        <div class="shipping-container">
            <div class="shipping-head">
                <label class="radio">
                    <input  <?php echo $selected; ?> <?php echo $disabled; ?> type="radio" class="" id="shippingid<?php echo $method->getId(); ?>" name="shippingid" value="<?php echo $method->getId(); ?>" data-needs-address-data="<?php echo $method->needsAddressData()?'true':'false'?>">
                    <span><?php echo $method->getDisplayName(); ?></span>
                    <?php $price = $method->getPrice($this->cart); if ($price->getAmount()>0) { echo "(" . $price . ")"; } ?>
                </label>
            </div>
            <?php IF(!empty($shippingBodyContent)): ?>
                <div class="shipping-body <?php echo $cssSelected?>"><?php echo $shippingBodyContent ?></div>
            <?php ENDIF; ?>
        </div>

        <?php ENDFOREACH ?>
    </div>
</div>

