<?php 

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Svenbluege\Component\Eventgallery\Site\Library\Manager\OrderManager;
use Svenbluege\Component\Eventgallery\Site\Library\Order;

defined('_JEXEC') or die('Restricted access');

/**
 * @var OrderManager $orderMgr
 * @var Order $order
 */
$orderMgr = OrderManager::getInstance();
$orders = $orderMgr->getOrders();

$order = null;
foreach($orders as $myorder) {
    $order = $myorder;
    break;
}

if ($order == null) {
    return;
}

?>

<div class="eventgallery-checkout eventgallery-confirm-page">

	<h1><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_CONFIRM_HEADLINE') ?></h1>
    <p class="successmessage"> <?php echo \Joomla\CMS\Language\Text::sprintf('COM_EVENTGALLERY_CART_CHECKOUT_CONFIRM_SUCCESS_MESSAGE', $order->getDocumentNumber(), $order->getEMail() ) ?></p>

    <?php $this->set('edit',false); $this->set('lineitemcontainer', $order); echo $this->loadSnippet('order/summary') ?>
	<div class="clearfix"></div>
</div>


<?php echo $this->loadSnippet('footer_disclaimer'); ?>
