<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Router\Route;
use Svenbluege\Component\Eventgallery\Site\Library\Database\Localizablestring;

defined('_JEXEC') or die('Restricted access');
/**
 * @var \de\svenbluege\joomla\eventgallery\ObjectWithConfiguration $this
 */


$disclaimerObject = new Localizablestring($this->config->getCheckout()->getCheckoutDisclaimer());
$disclaimer = !empty($disclaimerObject->get()) ? $disclaimerObject->get() : \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_ORDER_MAIL_CONFIRMATION_DISCLAIMER');
/**
 * @var $cart \Svenbluege\Component\Eventgallery\Site\Library\Cart
 */
$cart = $this->cart;

?>



<div class="eventgallery-checkout eventgallery-review-page">
    <h1><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_REVIEW_HEADLINE') ?></h1>
    <?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_REVIEW_TEXT') ?>&nbsp;

    <form action="<?php echo  Route::_("index.php?option=com_eventgallery&view=checkout&task=createOrder") ?>"
          method="post" class="form-validate form-horizontal checkout-form">

        <?php $this->set('edit',true); $this->set('lineitemcontainer',$cart); echo $this->loadSnippet('checkout/summary') ?>

        <div class="clearfix"></div>
        <fieldset>
            <?php IF ($this->config->getCheckout()->doUseTermsAndConditionsCheckbox()):?>
                <div class="control-group form-group">
                    <div class="controls row">
                        <div class="col-form-label col-sm-3 pt-0"></div>
                        <div class="col-sm-9">
                            <div class="form-check form-switch">
                                <input class="form-check-input validate required" type="checkbox" name="tac" id="tac">
                                <label class="form-check-label" for="tac" ><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_TERMCONDITIONS_CHECKBOX_LABEL') ?></label>
                            </div>
                            <?php IF($this->config->getCheckout()->doShowNewsletterOptIn()):?>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" name="newsletter_optin" id="newsletter_optin" <?php IF ($cart->isNewsletterOptIn()) echo 'checked="checked"'?>>
                                    <label class="form-check-label" for="newsletter_optin" ><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_NEWSLETTER_OPTIN_CHECKBOX_LABEL') ?></label>
                                </div>
                            <?php ENDIF?>
                        </div>
                    </div>
                </div>
            <?php ENDIF; ?>

            <div class="control-group form-group">
                <div class="controls row">
                    <div class="col-form-label col-sm-3 pt-0"></div>
                    <div class="col-sm-9">
                        <ul class="nav nav-pills">
                            <li class="nav-item"><a class="nav-link disclaimer" data-eventgallery-overlay="content" href="#mb_disclaimer"><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_REVIEW_DISCLAIMER')?></a></li>
                            <?php IF(!empty($this->config->getCheckout()->getPrivacyPolicyLink())):?>
                                <li class="nav-item"><a class="nav-link pp"       target="_blank" rel="nofollow" href="<?php echo $this->config->getCheckout()->getPrivacyPolicyLink();?>"><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_REVIEW_PRIVACYPOLICY');?></a></li>
                            <?php ENDIF?>
                            <?php IF(!empty($this->config->getCheckout()->getTermsAndConditionsLink())):?>
                                <li class="nav-item"><a class="nav-link tac"      target="_blank" rel="nofollow" href="<?php echo $this->config->getCheckout()->getTermsAndConditionsLink();?>"><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_REVIEW_TAC');?></a></li>
                            <?php ENDIF?>
                            <?php IF(!empty($this->config->getCheckout()->getImpressLink())):?>
                                <li class="nav-item"><a class="nav-link impress"  target="_blank" rel="nofollow" href="<?php echo $this->config->getCheckout()->getImpressLink();?>"><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_REVIEW_IMPRESS');?></a></li>
                            <?php ENDIF?>
                        </ul>
                    </div>
                </div>
            </div>
        </fieldset>

        <div style="display:none">
            <div id="mb_disclaimer" class="inline-content">
                <div class="eventgallery-checkout-disclaimer-content">
                    <?php echo $disclaimer; ?>
                </div>
            </div>
        </div>

        <fieldset>
            <div class="eg-form-actions">
                <div class="right">
                    <div class="btn-group">
                          <a class="btn btn-secondary" href="<?php echo  Route::_(
                                "index.php?option=com_eventgallery&view=checkout&task=change"
                            ) ?>"><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_REVIEW_FORM_CHANGE') ?></a>

                        <input name="continue" type="submit" class="btn btn-primary pull-right"
                               value="<?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_REVIEW_FORM_CONTINUE') ?>"/>
                    </div>
                </div>
            </div>
        </fieldset>
        <?php echo \Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
    </form>
</div>



<?php echo $this->loadSnippet('footer_disclaimer'); ?>
