<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
use Joomla\CMS\Router\Route;
use Svenbluege\Component\Eventgallery\Site\Library\Order;
defined('_JEXEC') or die('Restricted access');
?>

<div class="eventgallery-orders">
    <h1><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_ORDERS_HEADLINE')?></h1>
    <p>
        <?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_ORDERS_DESCRIPTION')?>
    </p>
    <table class="table">
        <thead>
            <tr>
                <th><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_ORDERS_NUMBER')?></th>
                <th><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_ORDERS_ITEMS')?></th>
                <th><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_ORDERS_TOTAL')?></th>
                <th><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_ORDERS_STATUS')?></th>
            </tr>
        </thead>
        <tbody>
        <?php /**@var Order $item*/FOREACH($this->items as $item):?>
            <tr>
                <td><a href="<?php echo  Route::_('index.php?option=com_eventgallery&view=order&id='.$item->getId())?>"><?php echo $item->getDocumentNumber(); ?></a><br></td>
                <td><a href="<?php echo  Route::_('index.php?option=com_eventgallery&view=order&id='.$item->getId())?>"><?php echo \Joomla\CMS\Language\Text::sprintf('COM_EVENTGALLERY_ORDERS_ITEMSPERORDER', $item->getLineItemsTotalCount(), $item->getLineItemsCount())?></a></td>
                <td><?php echo $item->getTotal()?></td>
                <td><?php echo $item->getOrderStatus()->getDisplayName()?></td>
            </tr>

        <?php ENDFOREACH; ?>
        </tbody>
    </table>
</div>
