<?php 
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\Registry\Registry;

defined('_JEXEC') or die('Restricted access'); ?>

<?php
$myApp = Factory::getApplication();
$myParams = $myApp->getParams();
$use_cart = $myParams->get('use_cart', '1') == 1;
$use_cart_inside_component = $myParams->get('use_cart_inside_component', '1') == 1;

?>

<?php IF ($use_cart): ?>

    <?php IF ($use_cart_inside_component): ?>
        <div class="eventgallery-minicart-container">

            <div class="eventgallery-minicart eventgallery-minicart-internal well">

                <h2><?php echo Text::_('COM_EVENTGALLERY_CART') ?></h2>

                <div class="cart-items-container">
                    <div class="cart-items"></div>
                </div>

                <div class="cart-summary btn-group">


                    <button title="<?php echo Text::_('COM_EVENTGALLERY_CART_ITEMS_DESCRIPTION') ?>" class="btn"><span class="itemscount">0</span> <?php echo Text::_('COM_EVENTGALLERY_CART_ITEMS') ?>
                    </button>
                    <button title="<?php echo Text::_('COM_EVENTGALLERY_CART_ITEMS_TOGGLE_DOWN') ?>" class="btn toggle-down"><i class="egfa egfa-chevron-down"></i></button>
                    <button title="<?php echo Text::_('COM_EVENTGALLERY_CART_ITEMS_TOGGLE_UP') ?>" class="btn toggle-up"><i class="egfa egfa-chevron-up"></i></button>
                    <button title="<?php echo Text::_('COM_EVENTGALLERY_CART_BUTTON_CART_DESCRIPTION') ?>" onclick="document.location.href='<?php echo  Route::_(
                        "index.php?option=com_eventgallery&view=cart"
                    ); ?>'" class="btn  btn-primary"><i class="egfa egfa-shopping-cart"></i> <?php echo Text::_('COM_EVENTGALLERY_CART_BUTTON_BUY') ?></button>


                </div>

            </div>
        </div>
    <?php ENDIF; ?>

<?php ELSE: ?>
    <style type="text/css">
        .eventgallery-add2cart {
            display: none !important;
        }
    </style>
<?php ENDIF; ?>
