<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */


use Joomla\CMS\Router\Route;
use Svenbluege\Component\Eventgallery\Site\Library\Common\View;

defined('_JEXEC') or die('Restricted access');
/**
 * @var \de\svenbluege\joomla\eventgallery\ObjectWithConfiguration|View $this
 */
$subCategories = $this->category->getChildren();
?>

<?php IF (isset($this->category)): ?>
    <?php IF ($this->category->id != 0 && $this->category->id != 'root'):?><h1 class="eventgallery-category-headline"><?php echo $this->escape(\Svenbluege\Component\Eventgallery\Site\Helper\CategoriesHelper::getCategoryTitle($this->category)); ?></h1><?php ENDIF ?>

    <p class="eventgallery-category-content"><?php echo \Joomla\CMS\HTML\HTMLHelper::_('content.prepare', \Svenbluege\Component\Eventgallery\Site\Helper\CategoriesHelper::getCategoryDescription($this->category), '', 'com_eventgallery.category'); ?></p>

    <?php IF (count($subCategories)>0): ?>
    <?php IF($this->config->getCategories()->doShowSubcategoryHeadline()):?>
        <h2 class="eventgallery-subcategories"><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_EVENTS_SUBCATEGORIES');?></h2>
    <?php ENDIF ?>
        <ul class="nav flex-column eventgallery-subcategories-list">
            <?php foreach($subCategories as $subCategory): ?>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo  Route::_('index.php?option=com_eventgallery&view=categories&catid='.$subCategory->id.'&Itemid='.$this->currentItemid) ?>" >
                        <?php echo $this->escape(\Svenbluege\Component\Eventgallery\Site\Helper\CategoriesHelper::getCategoryTitle($subCategory)); ?><?php if($this->config->getCategories()->doShowItemsPerCategoryCount()): ?>
                            (<?php if($this->config->getCategories()->doShowItemsPerCategoryCountRecursive()): ?><?php echo $subCategory->getNumItems(true); ?><?php ELSE: ?><?php echo $subCategory->getNumItems(false); ?><?php ENDIF; ?>)
                        <?php endif; ?>
                    </a>
                </li>
            <?php ENDFOREACH ?>
        </ul>
    <?php ENDIF; ?>
<?php ENDIF; ?>
