<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Svenbluege\Component\Eventgallery\Site\Library\Common\CSSRenderer;

defined('_JEXEC') or die('Restricted access');
/**
 * @var \de\svenbluege\joomla\eventgallery\ObjectWithConfiguration $this
 */


echo CSSRenderer::renderStyleTag($this->config->getCategories()->getCategoriesBreakpointJSON(), "div.eventgallery-subcategories .item-container");

?>
<?php IF (isset($this->category)): ?>
    <?php IF ($this->category->id != 0 && $this->category->id != 'root'):?><h1 class="eventgallery-category-headline"><?php echo $this->escape(\Svenbluege\Component\Eventgallery\Site\Helper\CategoriesHelper::getCategoryTitle($this->category)); ?></h1><?php ENDIF ?>

    <p class="eventgallery-category-content"><?php echo \Joomla\CMS\HTML\HTMLHelper::_('content.prepare', \Svenbluege\Component\Eventgallery\Site\Helper\CategoriesHelper::getCategoryDescription($this->category), '', 'com_eventgallery.category'); ?></p>

    <?php IF (count($this->subCategories)>0): ?>
        <div class="eventgallery-subcategories">
            <?php IF($this->config->getCategories()->doShowSubcategoryHeadline()):?>
                <h2 class="eventgallery-subcategories"><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_EVENTS_SUBCATEGORIES');?></h2>
            <?php ENDIF ?>


            <div class="eventgallery-events-gridlist">
                <?php foreach($this->subCategories as $subCategory): ?>

                    <?php $this->subCategory = $subCategory; echo $this->loadSnippet('categories/tiles_item'); ?>

                <?php ENDFOREACH ?>
                <div style="clear:both"></div>
            </div>

        </div>
    <?php ENDIF; ?>
<?php ENDIF; ?>
