<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Svenbluege\Component\Eventgallery\Site\Library\ImageLineitem;

defined('_JEXEC') or die('Restricted access');
/**
 * @var \de\svenbluege\joomla\eventgallery\ObjectWithConfiguration $this
 */
?>

<div class="cart-items">


        <?php foreach ($this->lineitemcontainer->getLineItems() as $lineitem) :
            /** @var ImageLineitem $lineitem */
             ?>
                    <div class="lineitem-container card-body">
                        <div class="image">
                            <?php echo $lineitem->getCartThumb(); ?>
                        </div>

                        <div class="information">
                           <span class="quantity"><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_LINEITEM_QUANTITY') ?>: <?php echo $lineitem->getQuantity() ?></span>
                           <?php $this->lineitem = $lineitem; echo $this->loadSnippet('/checkout/image_details'); ?>
                           <?php IF (!empty($lineitem->getBuyerNote())): ?>
                           <p class="buyernote"><blockquote><?php echo nl2br($this->escape($lineitem->getBuyerNote())); ?></blockquote></p>
                           <?php ENDIF; ?>
                            <p class="imagetype-details">
                                <?php IF($lineitem->getImageType() != null): ?>
                                    <span class="displayname"><?php echo $lineitem->getImageType()->getDisplayName() ?></span>
                                    <span class="description"><?php echo $lineitem->getImageType()->getDescription() ?></span>
                                    <?php IF($this->config->getCheckout()->doShowFileName()):?>
                                        <span class="filename"><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_IMAGE_ID'). $lineitem->getFolderName().'/'.$lineitem->getFileName() ?></span>
                                    <?php ENDIF?>
                                    <span class="singleprice"><?php echo \Joomla\CMS\Language\Text::sprintf('COM_EVENTGALLERY_LINEITEM_PRICE_PER_ITEM_WITH_PLACEHOLDER', $lineitem->getSinglePrice()) ?></span>
                                <?php ENDIF; ?>
                            </p>
                        </div>

                        <div class="price">
                            <?php echo $lineitem->isPriceIncluded()? \Joomla\CMS\Language\Text::_("COM_EVENTGALLERY_LINEITEM_PRICE_INCLUDED") : $lineitem->getPrice(); ?>
                        </div>

                    </div>

        <?php endforeach ?>
</div>
