<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Svenbluege\Component\Eventgallery\Site\Model\EventsModel;

defined('_JEXEC') or die('Restricted access');

/**
 * @var \de\svenbluege\joomla\eventgallery\ObjectWithConfiguration $this
 */

if ( !$this->config->getEventsList()->doUseBackButton()) {
    return;
}

$app = Factory::getApplication();

/* Default Page fallback*/

$active = $app->getMenu()->getActive();
if (NULL == $active) {
    $active = $app->getMenu()->getDefault();
}

$entriesPerPage = $this->config->getEventsList()->getMaxEventsPerPage();
$filterEventsByUserGroup = $this->config->getGeneral()->doHideUserGroupProtectedEventsInList();
/**
 * @var EventsModel $model
 */
$model = Factory::getApplication()->bootComponent('com_eventgallery')->getMVCFactory()->createModel('Events', 'Site');
$recursive = $this->config->getCategories()->doShowItemsPerCategoryRecursive();
$user = Factory::getUser();
$usergroups = \Joomla\CMS\User\UserHelper::getUserGroups($user->id);
$viewname = $active->query['view'];


$catid = $this->config->getEventsList()->getCatId();
if ($viewname == 'categories' && $this->category != null) {
    $catid = $this->category->id;
}

$entries = $model->getEntries(true, 0, -1, $this->config->getEventsList()->getTags(), $this->config->getEventsList()->getSortByEvents(), $usergroups, $catid, $recursive, $filterEventsByUserGroup);

$pos = 0;
foreach($entries as $entry) {
    if ($entry->getId() == $this->folder->getId()) {

        break;
    }
    $pos++;
}

$limitstart = 0;
if ($entriesPerPage > 0) {
    $limitstart = $pos - ($pos % $entriesPerPage);
}


$link = null;

if ($viewname == 'events') {

    $link = "index.php?option=com_eventgallery&Itemid=" . $this->currentItemid;

    if ($limitstart > 0 ) {
        $link .= "&limitstart=". (int)$limitstart;
    }

    $link =  Route::_($link);
}

if ($viewname == 'categories') {

    // the categories view uses the catid as query parameter, the events view as param

    $link = "index.php?option=com_eventgallery&Itemid=" . $this->currentItemid;
    if (isset($this->category) && $this->category->id != 'root') {
        $link .= "&view=categories&catid=".$this->category->id;
    }

    if ($limitstart > 0 ) {
        $link .= "&limitstart=". (int)$limitstart;
    }

    $link =  Route::_($link);
}



?>
<?php IF ($link != null ) : ?>
    <a class="eventgallery-back-button" href="<?php echo $link; ?>"><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_EVENT_BACK_BUTTON_LABEL')?></a>
<?php ENDIF ?>


