<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die('Restricted access');
/**
 * @var \de\svenbluege\joomla\eventgallery\ObjectWithConfiguration $this
 */
use \Joomla\CMS\Router\Route;
?>

<div class="eventgallery-thumbnails eventgallery-imagelist thumbnails"
						data-rowheight="<?php echo $this->config->getEventImagelist()->getThumbnailHeight(); ?>"
	                    data-rowheightjitter="<?php echo $this->config->getEventImagelist()->getThumbnailJitter(); ?>"
	                    data-firstimagerowheight="<?php echo $this->config->getEventImagelist()->getFirstItemRowHeight(); ?>"
	                    data-dofilllastrow="<?php echo (isset($this->dofilllastrow) && $this->dofilllastrow==true)?"true":"false"; ?>">
    <?php foreach ($this->entries as $entry) : /** @var \Svenbluege\Component\Eventgallery\Site\Library\File\File $entry */ ?>
        <?php
            $folder = $entry->getFolder();
            $this->link = Route::_(\Svenbluege\Component\Eventgallery\Site\Library\Helper\Route::createEventRoute($folder->getFolderName(), $folder->getTags(), $folder->getCategoryId(), $this->config->getMenuItem()->getMenuItemId()));
        ?>
        <div class="thumbnail-container">
            <?php $this->showContent=true; $this->entry=$entry; $this->cssClass="img-thumbnail thumbnail"; echo $this->loadSnippet('event/inc/thumb'); ?>
        </div>
    <?php endforeach ?>
    <div style="clear: both"></div>
</div>
