<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Svenbluege\Component\Eventgallery\Site\Library\File\File;

defined('_JEXEC') or die('Restricted access');

$app = Factory::getApplication();
/**
 * @var \Svenbluege\Component\Eventgallery\Site\Library\File\File $entry
 */
$entry = $this->entry;

/**
 * @var \de\svenbluege\joomla\eventgallery\ObjectWithConfiguration $this
 */
?><?php IF (!$entry->hasUrl()):?><a class="event-thumbnail <?php if (isset($this->cssClass)) {echo $this->cssClass;}?>"

    <?php IF ($entry->isVideo()):?>
        href="<?php echo $entry->getVideoUrl()?>"
        data-type="<?php echo File::TYPE_VIDEO ?>"
    <?php ELSE: ?>
        href="<?php echo $entry->getImageUrl(null, null, true); ?>"
        data-type="<?php echo File::TYPE_IMAGE ?>"
        data-eg-srcset="<?php echo $entry->getImageSrcSet(); ?>"
    <?php ENDIF; ?>
   name="<?php echo $entry->getId();?>"
   title="<?php echo htmlspecialchars($entry->getPlainTextTitle($this->config->getEvent()->doShowImageTitle(), $this->config->getEvent()->doShowImageCaption()), ENT_COMPAT, 'UTF-8') ?>"
   data-pid="<?php echo $entry->getId();?>"
   data-width="<?php echo $entry->getLightboxImageWidth();?>"
   data-height="<?php echo $entry->getLightboxImageHeight();?>"
   data-title="<?php echo rawurlencode($entry->getLightBoxTitle($this->config->getEvent()->doShowImageFilename(), $this->config->getEvent()->doShowExif(), $this->config->getEvent()->doShowImageTitle(), $this->config->getEvent()->doShowImageCaption())) ?>"
   data-gid="gallery<?php if (isset($this->rel)) {echo $this->rel;} echo md5($entry->getFolderName()); ?>"
   data-eg-lightbox="gallery"><?php echo $entry->getLazyThumbImgTag(50, 50, "", false, null, $this->config->getEvent()->doShowImageTitle(), $this->config->getEvent()->doShowImageCaption() ); ?>
   <?php echo $this->loadSnippet('event/inc/thumbs_content'); ?>
   <div class="eventgallery-icon-container"><?php echo $this->loadSnippet('event/inc/icons'); ?></div>
</a>
<?php ELSE: ?>
<a class="event-thumbnail <?php if (isset($this->cssClass)) {echo $this->cssClass;}?>" href="<?php echo $entry->getUrl();?>"
   title="<?php echo htmlspecialchars($entry->getPlainTextTitle($this->config->getEvent()->doShowImageTitle(), $this->config->getEvent()->doShowImageCaption()), ENT_COMPAT, 'UTF-8') ?>">
   <?php echo $entry->getLazyThumbImgTag(50, 50, "", false, null, $this->config->getEvent()->doShowImageTitle(), $this->config->getEvent()->doShowImageCaption()); ?>
   <?php echo $this->loadSnippet('event/inc/thumbs_content'); ?>
</a>
<?php ENDIF;

