<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die('Restricted access');
/**
 * @var \de\svenbluege\joomla\eventgallery\ObjectWithConfiguration $this
 */
use Joomla\CMS\Router\Route;
use Svenbluege\Component\Eventgallery\Site\Library\Common\CSSRenderer;


echo CSSRenderer::renderStyleTag($this->config->getEventGrid()->getBreakpointJSON(), "div.eventgallery-simplelist .eventgallery-simplelist-tile");
?>

<div class="eventgallery-event-gridlist">
	<div class="eventgallery-simplelist eventgallery-thumbnails thumbnails" <?php echo $this->config->getSlider()->getJavaScriptConfigurationString('.thumbnail-container'); ?>>
	    <?php foreach ($this->entries as $entry) : /** @var \Svenbluege\Component\Eventgallery\Site\Library\File\File $entry */ ?>
            <?php
                $folder = $entry->getFolder();
                $this->link = Route::_(\Svenbluege\Component\Eventgallery\Site\Library\Helper\Route::createEventRoute($folder->getFolderName(), $folder->getTags(), $folder->getCategoryId(), $this->config->getMenuItem()->getMenuItemId()));
            ?>
	        <div class="eventgallery-simplelist-tile thumbnail-container">
	            <div class="event-thumbnails">
	                <?php $this->entry=$entry; $this->cssClass="img-thumbnail thumbnail"; echo $this->loadSnippet('event/inc/thumb'); ?>
	            </div>
	        </div>

	    <?php endforeach ?>
	</div>
</div>
