<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die('Restricted access');
/**
 * @var \de\svenbluege\joomla\eventgallery\ObjectWithConfiguration $this
 */
use Joomla\CMS\Router\Route;
use Svenbluege\Component\Eventgallery\Site\Library\Common\CSSRenderer;
echo CSSRenderer::renderStyleTag($this->config->getEventTiles()->getBreakpointJSON(), "div.eventgallery-tiles-list .eventgallery-tile");
?>

<div class="eventgallery-tiles-list eventgallery-event-tiles-list">
    <div class="eventgallery-tiles eventgallery-thumbnails thumbnails">
        <?php foreach ($this->entries as $entry) : /** @var \Svenbluege\Component\Eventgallery\Site\Library\File\File $entry */ ?>
            <?php
                $folder = $entry->getFolder();
                $this->link = Route::_(\Svenbluege\Component\Eventgallery\Site\Library\Helper\Route::createEventRoute($folder->getFolderName(), $folder->getTags(), $folder->getCategoryId(), $this->config->getMenuItem()->getMenuItemId()));
            ?>
            <div class="eventgallery-tile thumbnail-container">
                <div class="wrapper">
                    <div class="event-thumbnails">
                        <?php $this->showContent=false; $this->entry=$entry; $this->cssClass=""; echo $this->loadSnippet('event/inc/thumb'); ?>
                        <div style="clear: both"></div>
                    </div>
                     <?php $this->showContent=true; $this->entry=$entry; echo $this->loadSnippet('event/inc/thumbs_content'); ?>
                </div>
            </div>
        <?php endforeach ?>
        <div style="clear: both"></div>
    </div>
</div>
