<?php 
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Svenbluege\Component\Eventgallery\Site\Library\ImageTypeSet;
use Svenbluege\Component\Eventgallery\Site\Library\Manager\CartManager;

defined('_JEXEC') or die('Restricted access');

/**
 * @var ImageTypeSet $imagetypeset
 */
$imagetypeset = $this->imageset;

if ($imagetypeset == null) {
    return;
}

$file = $this->file;
$imagetypes = $imagetypeset->getImageTypes(true);
/**
 * @var CartManager $cartMgr
 * @var \Svenbluege\Component\Eventgallery\Site\Library\File\File $file
 */

foreach ($imagetypes as $imagetype) {
    $cartMgr = CartManager::getInstance();
    $cart = $cartMgr->getCart();
    $cart->addItem($file->getFolderName(), $file->getFileName(), 1, $imagetype->getId(), true, true);
    $cartMgr->calculateCart();
}
?>

<div id="eg-single-image-type-action-needed" class="alert alert-success"><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_PRODUCT_BUY_IMAGES_CONFIRM_ADDING_SINGLE_IMAGE') ?> </div>
<style>
    .imageset .quantityselection,
    .imageset .group,
    .imageset .imagetypegroups,
    .imageset .imageset-description {
        display:none;
    }
</style>
<?php echo $this->loadSnippet('imageset/imageselection/details'); ?>
