<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Router\Route;

defined('_JEXEC') or die('Restricted access');
/**
 * @var \de\svenbluege\joomla\eventgallery\ObjectWithConfiguration $this
  * @var \Svenbluege\Component\Eventgallery\Site\Library\File\File $file
 */

$file = $this->file;
$folder = $file->getFolder();
$this->imageset = $file->getImageTypeSet();

if (!$folder->isCartable()  || !$this->config->getCart()->doUseCart()) {
    return;
}

?>

<div class="imagetypeselection-container">
    <div class="imagetypeselection">


        <?php
        if (count($this->imageset->getImageTypes(true)) == 1) {
            echo $this->loadSnippet('imageset/imageselection/single');
        } else {
            echo $this->loadSnippet('imageset/imageselection/multiple');
        }
        ?>


        <div class="btn-group pull-right">
            <button class="btn btn-primary eventgallery-close-overlay" title="<?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_PRODUCT_BUY_IMAGES_CLOSE_DESCRIPTION') ?>"><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_PRODUCT_BUY_IMAGES_CLOSE') ?></button>
            <button class="btn btn-default btn-secondary eventgallery-opencart" disabled title="" onclick="document.location.href='<?php echo  Route::_(
                "index.php?option=com_eventgallery&view=cart"
            ); ?>'"><i class="egfa egfa-shopping-cart"></i> <?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_PRODUCT_BUY_IMAGES_OPEN_CART') ?></button>
        </div>

        <div class="clearfix"></div>
    </div>
</div>
