<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Svenbluege\Component\Eventgallery\Site\Library\ImageType;

defined('_JEXEC') or die('Restricted access');

/**
 * @var ImageType $imagetype
 */

$imagetype = $this->imagetype;
$scaleprices = $imagetype->getScalePrices();
if (count($scaleprices) == 0) {
    return;
}

if ($imagetype->getScalePriceType() == ImageType::SCALEPRICE_TYPE_PACKAGE
    && $imagetype->getScalePriceScope() == ImageType::SCALEPRICE_SCOPE_IMAGETYPE) {
    echo $this->loadSnippet('imageset/scaleprice/package_imagetype');
}

if ($imagetype->getScalePriceType() == ImageType::SCALEPRICE_TYPE_PACKAGE
    && $imagetype->getScalePriceScope() == ImageType::SCALEPRICE_SCOPE_LINEITEM) {
    echo $this->loadSnippet('imageset/scaleprice/package_lineitem');
}

if ($imagetype->getScalePriceType() == ImageType::SCALEPRICE_TYPE_SINGLEPACKAGE
    && $imagetype->getScalePriceScope() == ImageType::SCALEPRICE_SCOPE_IMAGETYPE) {
    echo $this->loadSnippet('imageset/scaleprice/singlepackage_imagetype');
}

if ($imagetype->getScalePriceType() == ImageType::SCALEPRICE_TYPE_SINGLEPACKAGE
    && $imagetype->getScalePriceScope() == ImageType::SCALEPRICE_SCOPE_LINEITEM) {
    echo $this->loadSnippet('imageset/scaleprice/singlepackage_lineitem');
}

if ($imagetype->getScalePriceType() == ImageType::SCALEPRICE_TYPE_DISCOUNT
    && $imagetype->getScalePriceScope() == ImageType::SCALEPRICE_SCOPE_IMAGETYPE) {
    echo $this->loadSnippet('imageset/scaleprice/discount_imagetype');
}

if ($imagetype->getScalePriceType() == ImageType::SCALEPRICE_TYPE_DISCOUNT
    && $imagetype->getScalePriceScope() == ImageType::SCALEPRICE_SCOPE_LINEITEM) {
    echo $this->loadSnippet('imageset/scaleprice/discount_lineitem');
}
