<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */


use Svenbluege\Component\Eventgallery\Site\Library\Database\Localizablestring;

defined('_JEXEC') or die('Restricted access');

/**
 * @var \de\svenbluege\joomla\eventgallery\ObjectWithConfiguration $this
 */


$ls = new Localizablestring($this->config->getEventsList()->getGreetings());
$greetings = \Joomla\CMS\HTML\HTMLHelper::_('content.prepare', $ls->get(), '', 'com_eventgallery.event');

?>

<?php IF ($this->config->getMenuItem()->doShowPageHeading()) : ?>
    <div class="page-header">
        <h1> <?php echo $this->escape($this->config->getMenuItem()->getPageHeading()); ?> </h1>
    </div>
<?php ENDIF; ?>

<?php IF (!empty($greetings)): ?>
    <p class="greetings"><?php echo $greetings; ?></p>
<?php ENDIF; ?>
