<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Router\Route;
use Svenbluege\Component\Eventgallery\Site\Library\Address;
use Svenbluege\Component\Eventgallery\Site\Library\Common\GeoObjects;

defined('_JEXEC') or die('Restricted access');
/**
 * @var \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main $config;
 */
$config = $this->config;
/**
 * @var Address $address
 */
$address = $this->address;

/**
* PARAMS:
* - address
*/


/*
US Format

Name
Street Address or PO Box
City, State, Zip

EU Format

Name
Street address
Zip, City
State
*/
?>

<?php IF (!empty($address->getCompanyName())):?>
    <?php echo $this->escape($address->getCompanyName()); ?><br/>
<?php ENDIF; ?>
<?php echo $this->escape($address->getFirstName()); ?> <?php echo $this->escape($address->getLastName()) ?> <br/>
<?php echo $this->escape($address->getAddress1()); ?><br/>
<?php IF (!empty($address->getAddress2())):?>
    <?php echo $this->escape($address->getAddress2()); ?><br/>
<?php ENDIF; ?>
<?php IF (!empty($address->getAddress3())):?>
    <?php echo $this->escape($address->getAddress3()); ?><br/>
<?php ENDIF; ?>

<?php IF ($config->getCheckout()->getAddressFormat() == 'us'): ?>
    <?php echo $this->escape($address->getCity()); ?>,
    <?php IF (!empty($address->getState())):?>
        <?php echo $this->escape(GeoObjects::getStateID($address->getState())); ?>,
    <?php ENDIF; ?>
    <?php echo $this->escape($address->getZip()); ?>

    <?php IF (!empty($address->getCountry())):?>
        <br/><?php echo $this->escape(GeoObjects::getCountryName($address->getCountry())); ?>
    <?php ENDIF; ?>
<?PHP ELSE: ?>
    <?php echo $this->escape($address->getZip()); ?> <?php echo $this->escape($address->getCity()); ?>
    <?php IF (!empty($address->getState())):?>
        <br/><?php echo $this->escape(GeoObjects::getStateName($address->getState())); ?>
    <?php ENDIF; ?>
    <?php IF (!empty($address->getCountry())):?>
        <br/><?php echo $this->escape(GeoObjects::getCountryName($address->getCountry())); ?>
    <?php ENDIF; ?>
<?PHP ENDIF; ?>

<?php IF (isset($this->edit) && $this->edit == true) :?>
    <p>
        <a href="<?php echo  Route::_(
            "index.php?option=com_eventgallery&view=checkout&task=change"
        ) ?>">(<?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_REVIEW_FORM_CHANGE') ?>)</a>
    </p>
<?php ENDIF ?>
