<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Router\Route;
use Svenbluege\Component\Eventgallery\Site\Library\LineitemContainer;

defined('_JEXEC') or die('Restricted access');
/**
 * @var LineitemContainer $lineitemcontainer
 */
$lineitemcontainer = $this->lineitemcontainer;
?>
<div class="address-and-payment-information">
    <?php IF ($lineitemcontainer->getBillingAddress() != null):?>
        <div class="review-billing-address">
            <h2><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_REVIEW_BILLINGADDRESS_HEADLINE') ?></h2>
            <?php $this->set('address',$lineitemcontainer->getBillingAddress()); echo $this->loadSnippet('order/address') ?>
        </div>
    <?php ENDIF ?>

    <?php IF ($lineitemcontainer->getShippingAddress() != null):?>
        <div class="review-shipping-address">
            <h2><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_REVIEW_SHIPPINGADDRESS_HEADLINE') ?></h2>
            <?php $this->set('address',$lineitemcontainer->getShippingAddress()); echo $this->loadSnippet('order/address') ?>
        </div>
    <?php ENDIF ?>

    <?php IF ($lineitemcontainer->getPaymentMethodServiceLineItem() != null):?>
        <div class="review-payment">
            <h2><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_REVIEW_PAYMENT_HEADLINE') ?></h2>
            <p><strong><?php echo $lineitemcontainer->getPaymentMethodServiceLineItem()->getMethod()->getDisplayName(); ?></strong></p>

            <?php IF (isset($this->edit) && $this->edit == true) :?>
                <p><?php echo $lineitemcontainer->getPaymentMethodServiceLineItem()->getMethod()->getMethodReviewContent($lineitemcontainer, false);?></p>
                <p>
                <a href="<?php echo  Route::_(
                    "index.php?option=com_eventgallery&view=checkout&task=change"
                ) ?>">(<?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_CHECKOUT_REVIEW_FORM_CHANGE') ?>)</a>
                </p>
            <?php ELSE: ?>
                <p><?php echo $lineitemcontainer->getPaymentMethodServiceLineItem()->getMethod()->getMethodConfirmContent($lineitemcontainer, false);?></p>
            <?php ENDIF ?>
        </div>
    <?php ENDIF ?>
</div>
