<?php 

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Svenbluege\Component\Eventgallery\Site\Library\LineitemContainer;

defined('_JEXEC') or die('Restricted access');

/**
 * @var LineitemContainer $lineitemcontainer
 */
$lineitemcontainer = $this->lineitemcontainer;
?>

<div class="basic-information">
    <?php IF (!$lineitemcontainer->getShippingMethod()->needsAddressData()): ?>
        <p class="basic-name">
            <strong><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CHECKOUT_USERDATA_NAME_LABEL') ?></strong><br />
            <?php echo $this->escape($lineitemcontainer->getFirstname()) ?> <?php echo $this->escape($lineitemcontainer->getLastname()) ?>
        </p>
    <?php ENDIF; ?>

    <p class="basic-email"><strong><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CHECKOUT_USERDATA_EMAIL_LABEL') ?></strong><br />
        <?php echo $this->escape($lineitemcontainer->getEMail()) ?>
    </p>

    <?php IF (!empty($lineitemcontainer->getPhone())):?>
        <p class="basic-phone"><strong><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CHECKOUT_USERDATA_PHONE_LABEL') ?></strong><br />
            <?php echo $this->escape($lineitemcontainer->getPhone()) ?>
        </p>
    <?php ENDIF; ?>

    <?php IF (null != $lineitemcontainer->getBillingAddress() && !empty($lineitemcontainer->getBillingAddress()->getTaxId()) ):?>
        <p class="basic-vat"><strong><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CHECKOUT_BILLINGFORM_TAXID_LABEL') ?></strong><br />
            <?php echo $this->escape($lineitemcontainer->getBillingAddress()->getTaxId()); ?>
        </p>
    <?php ENDIF; ?>

    <?php IF (!empty($lineitemcontainer->getMessage())):?>
        <p class="basic-message"><strong><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CHECKOUT_USERDATA_MESSAGE_LABEL') ?></strong><br />
            <?php echo $this->escape($lineitemcontainer->getMessage()) ?>
        </p>
    <?php ENDIF; ?>


</div>
