<?php 

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Svenbluege\Component\Eventgallery\Site\Library\LineitemContainer;

defined('_JEXEC') or die('Restricted access');

?>

<?php

/**
 * @var LineitemContainer $lineitemcontainer
 */
$lineitemcontainer = $this->lineitemcontainer;
$contentShipping = "";
$contentSurcharge = "";

if ($lineitemcontainer->getShippingMethodServiceLineItem() != NULL) {
    if (isset($this->isReview) && $this->isReview == true) {
        $contentShipping = $lineitemcontainer->getShippingMethodServiceLineItem()->getMethod()->getMethodReviewContent($lineitemcontainer, false);
    } else {
        $contentShipping = $lineitemcontainer->getShippingMethodServiceLineItem()->getMethod()->getMethodConfirmContent($lineitemcontainer, false);
    }
}
if ($lineitemcontainer->getSurchargeServiceLineItem() != NULL) {
    if (isset($this->isReview) && $this->isReview == true) {
        $contentSurcharge = $lineitemcontainer->getSurchargeServiceLineItem()->getMethod()->getMethodReviewContent($lineitemcontainer, false);
    } else {
        $contentSurcharge = $lineitemcontainer->getSurchargeServiceLineItem()->getMethod()->getMethodConfirmContent($lineitemcontainer, false);
    }
}

if (empty($contentShipping) && empty($contentSurcharge)) {
    return;
}

?>

<div class="card-body">
    <div class="methodinformation">

        <?php IF (!empty($contentShipping)): ?>
            <p class="shipping-content">
                <?php echo $contentShipping?>
            </p>
        <?php ENDIF; ?>

        <?php IF (!empty($contentSurcharge)): ?>
            <p class="surcharge-content">
                <?php echo $contentSurcharge?>
            </p>
        <?php ENDIF; ?>
    </div>
</div>
