<?php 

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Svenbluege\Component\Eventgallery\Site\Library\Order;

defined('_JEXEC') or die('Restricted access');

/**
 * @var Order $order
 */
$order = $this->lineitemcontainer;

?>
<div class="card">
    <div class="card-header">
        <?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_ORDER_LABEL') ?>
    </div>
    <div class="card-body order-status">
        <div class="order-status-id">
            <div class="order-status-headline"><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_ORDER_ID') ?></div>
            <div class="order-status-body"><?php echo $order->getDocumentNumber(); ?></div>
        </div>
        <div class="order-status-date">
            <div class="order-status-headline"><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_ORDER_CREATED') ?></div>
            <div class="order-status-body"><?php echo $order->getCreationDate(); ?></div>
        </div>
        <div class="order-status-order">
            <div class="order-status-headline"><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_ORDER_STATUS_ORDER') ?></div>
            <div class="order-status-body"><?php echo $order->getOrderStatus() ? $order->getOrderStatus()->getDisplayName() :'n/a'?></div>
        </div>
        <div class="order-status-payment">
            <div class="order-status-headline"><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_ORDER_STATUS_PAYMENT') ?></div>
            <div class="order-status-body"><?php echo $order->getPaymentStatus() ? $order->getPaymentStatus()->getDisplayName() : 'n/a'; ?></div>
        </div>
        <div class="order-status-shipping">
            <div class="order-status-headline"><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_ORDER_STATUS_SHIPPING') ?></div>
            <div class="order-status-body"><?php echo $order->getShippingStatus() ? $order->getShippingStatus()->getDisplayName() : 'n/a'; ?></div>
        </div>
    </div>
</div>
