<?php 

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die('Restricted access');
/**
 * @var \de\svenbluege\joomla\eventgallery\ObjectWithConfiguration $this
 */
?>
<div class="cart-summary">
    <table class="cart-summary-table">
        <tr class="subtotal">
            <td class="subtotal-headline eg-total-headline"><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_SUBTOTAL') ?></td>
            <td class="subtotal eg-total-amount">
                <?php echo $this->lineitemcontainer->getSubTotal(); ?>
            </td>
        </tr>
        <?php IF ($this->lineitemcontainer->getSurchargeServiceLineItem() != NULL): ?>
            <tr class="surcharge">
                <td class="surcharge-headline eg-total-headline">
                    <?php echo $this->lineitemcontainer->getSurchargeServiceLineItem()->getDisplayName(); ?>
                </td>
                <td class="surcharge eg-total-amount">
                    <?php echo $this->lineitemcontainer->getSurchargeServiceLineItem()->getPrice(); ?>
                </td>
            </tr>
        <?php ENDIF ?>
        <?php IF ($this->lineitemcontainer->getShippingMethodServiceLineItem() != NULL): ?>
            <tr class="shipping">
                <td class="shipping-headline eg-total-headline">
                    <?php echo $this->lineitemcontainer->getShippingMethodServiceLineItem()->getDisplayName(); ?>
                </td>
                <td class="shipping eg-total-amount">
                    <?php echo $this->lineitemcontainer->getShippingMethodServiceLineItem()->getPrice(); ?>
                </td>
            </tr>
        <?php ENDIF ?>
        <?php IF ($this->lineitemcontainer->getPaymentMethodServiceLineItem() != NULL): ?>
            <tr class="payment">
                <td class="payment-headline eg-total-headline"><?php echo $this->lineitemcontainer->getPaymentMethodServiceLineItem()->getDisplayName(); ?></td>
                <td class="payment eg-total-amount">
                    <?php echo $this->lineitemcontainer->getPaymentMethodServiceLineItem()->getPrice(); ?>
                </td>
            </tr>
        <?php ENDIF ?>
        <tr class="total ">
            <td class="total-headline eg-total-headline"><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_CART_TOTAL') ?></td>
            <td class="total eg-total-amount">
                <?php echo $this->lineitemcontainer->getTotal(); ?>
            </td>
        </tr>
        <?php IF ($this->config->getCheckout()->doShowVat()): ?>
        <tr>
            <td class="vat eg-total-amount" colspan="2">
                <?php echo \Joomla\CMS\Language\Text::sprintf('COM_EVENTGALLERY_CART_VAT_HINT_WITH_PLACEHOLDER', $this->lineitemcontainer->getTax()) ?>
            </td>
        </tr>
        <?php ENDIF ?>
    </table>
</div>
