<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
defined('_JEXEC') or die('Restricted access');
?>

<legend><?php echo Text::_('COM_EVENTGALLERY_TRACKORDER_FORM_LABEL');?></legend>
<form action="<?php echo Route::_('index.php?option=com_eventgallery&view=trackorder&task=order'); ?>" method="GET" class="form-vertical">
    <input type="hidden" name="task" value="order">
    <fieldset class="well">
        <div class="desc">
            <small><?php echo Text::_('COM_EVENTGALLERY_TRACKORDER_FORM_DESC');?></small>
        </div>
        <?php foreach ($this->form->getFieldset('credentials') as $field) : ?>
            <?php if (!$field->hidden) : ?>
                <div class="control-group form-group">
                    <div class="control-label">
                        <?php echo $field->label; ?>
                    </div>
                    <div class="controls">
                        <?php echo $field->input; ?>
                    </div>
                </div>
            <?php endif; ?>
        <?php endforeach; ?>

        <div class="control-group form-group">
            <div class="controls">
            <input class="btn btn-primary" type="submit" name="submit"
                   value="<?php echo Text::_('COM_EVENTGALLERY_TRACKORDER_FORM_SUBMIT_LABEL') ?>">
            </div>
        </div>
    </fieldset>
    <?php //echo \Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
</form>
