<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Plugin\Content\EventgalleryFieldsCategory\Extension;
use Joomla\CMS\Factory;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Event\SubscriberInterface;

defined('_JEXEC') or die;

class FieldsCategory extends CMSPlugin implements SubscriberInterface{

    protected $allowLegacyListeners = false;

    public function init() {
        $this->loadLanguage();
    }

    public static function getSubscribedEvents(): array
    {
        return [
            'onContentPrepareForm'     => 'contentPrepareForm',
        ];
    }

    function contentPrepareForm($event) {
        $form = $event->getArgument(0);
        $data = $event->getArgument(1);

        $app = $this->getApplication();
        $option = $app->input->get('option');

        switch($option) {

            case 'com_categories':
                if ($app->isClient('administrator')) {
                    $form_path = (JPATH_SITE . '/plugins/content/eventgallery_fields_category/forms/content.xml');

                    /**
                     * @var Form $form
                     */

                    $form->loadFile($form_path, false);

                }

                return true;

        }

        return true;

    }

}
