<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') || die;

use Joomla\CMS\Factory;
use Joomla\Filesystem\File;
use Joomla\Filesystem\Folder;
use Joomla\CMS\Installer\Adapter\ComponentAdapter;
use Joomla\CMS\Log\Log;

class plgContentEventgallery_multilangcontentInstallerScript
{
    /**
     * Obsolete files and folders to remove. Use path names relative to the site's root.
     *
     * @var   array
     */
    protected $removeFiles = [
        'files'   => [
            'plugins/content/eventgallery_multilangcontent/eventgallery_multilangcontent.php',
            'plugins/content/eventgallery_multilangcontent/language/en-GB/en-GB.plg_content_eventgallery_multilangcontent.ini',
            'plugins/content/eventgallery_multilangcontent/language/en-GB/en-GB.plg_content_eventgallery_multilangcontent.sys.ini',
        ],
        'folders' => [

        ],
    ];

    /**
     * Runs after install, update or discover_update. In other words, it executes after Joomla! has finished installing
     * or updating your component. This is the last chance you've got to perform any additional installations, clean-up,
     * database updates and similar housekeeping functions.
     *
     * @param   string            $type    install, update or discover_update
     * @param   ComponentAdapter  $parent  Parent object
     *
     * @return  void
     * @throws Exception
     *
     */
    public function postflight($type, $parent)
    {
        // Do not run on uninstall.
        if ($type === 'uninstall')
        {
            return true;
        }

        // Remove obsolete files and folders
        $this->removeFilesAndFolders($this->removeFiles);
    }

    /**
     * Removes obsolete files and folders
     *
     * @param   array  $removeList  The files and directories to remove
     */
    protected function removeFilesAndFolders($removeList)
    {
        // Remove files
        if (isset($removeList['files']) && !empty($removeList['files']))
        {
            foreach ($removeList['files'] as $file)
            {
                $f = JPATH_ROOT . '/' . $file;

                if (!is_file($f))
                {
                    continue;
                }

                File::delete($f);
            }
        }

        // Remove folders
        if (isset($removeList['folders']) && !empty($removeList['folders']))
        {
            foreach ($removeList['folders'] as $folder)
            {
                $f = JPATH_ROOT . '/' . $folder;

                if (!is_dir($f))
                {
                    continue;
                }

                Folder::delete($f);
            }
        }
    }

}
