<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Plugin\Content\EventgalleryMultilangContent\Extension;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Version;
use Joomla\Event\Event;
use Joomla\Event\SubscriberInterface;
use Svenbluege\Component\Eventgallery\Site\Library\Database\Localizablestring;

defined('_JEXEC') or die;

/**
 * Eventgallery Multi Language plugin
 *
 * We need this plugin to transform JSON data into something readable. This might happen if we render list of tags. Since
 * Event Gallery stores information encoded in JSON we need to trigger a transformation here.
 *
 */
class MultilangContent extends CMSPlugin implements SubscriberInterface
{
    protected $allowLegacyListeners = false;

    public function init() {

    }

    public static function getSubscribedEvents(): array
    {
        return [
            'onContentPrepare'     => 'contentPrepare',
        ];
    }

    /**
     * @param Event $event
     * @return void
     */
    public function contentPrepare($event)
    {
        $args = $event->getArguments();
        if (Version::MAJOR_VERSION > 4) {
            $context = $args['context'];
            $row = $args['subject'];
            $params = $args['params'];
        } else {
            $context = $args[0];
            $row = $args[1];
            $params = $args[2];
        }

        $canProceed = in_array($context, array('com_tags.tag', 'com_search.search') );

        if (!$canProceed)
        {
            return;
        }

        if (isset($row->core_title)) {
            $title = new Localizablestring($row->core_title);
            $row->core_title = $title->get();
        }

        if (isset($row->core_body)) {
            $body= new Localizablestring($row->core_body);
            $row->core_body = $body->get();
        }

        if (isset($row->text)) {
            $text= new Localizablestring($row->text);
            $row->text = $text->get();
        }
    }

}
