<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') || die;

use Joomla\CMS\Extension\PluginInterface;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Joomla\Event\DispatcherInterface;
use Svenbluege\Plugin\Content\Eventgallery\Extension\Eventgallery;
use Svenbluege\Plugin\EventgalleryPayment\Standard\Extension\StandardPlugin;

return new class implements ServiceProviderInterface {

    public function register(Container $container)
    {
        $container->set(
            PluginInterface::class,
            function (Container $container) {
                $subject = $container->get(DispatcherInterface::class);
                $config = (array)PluginHelper::getPlugin('eventgallery_pay', 'standard');

                $plugin = new StandardPlugin($subject, $config);

                $plugin->setApplication(\Joomla\CMS\Factory::getApplication());

                $plugin->init();

                return $plugin;
            }
        );
    }
};
