<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Plugin\EventgalleryPayment\Standard\Workingclass;

use Joomla\CMS\Factory;
use Svenbluege\Component\Eventgallery\Site\Library\Database\Localizablestring;
use Svenbluege\Component\Eventgallery\Site\Library\Methods\PaymentMethod;

defined('_JEXEC') or die();

class Standard extends PaymentMethod
{

    public function __construct($object)
    {
        Factory::getApplication()->bootPlugin('standard', 'eventgallery_pay');
        parent::__construct($object);
    }

    static public  function getClassName() {
        return "Payment: Standard";
    }

    public function onPrepareAdminForm($form) {

       /**
         * disable the default data field
         */
        $form->setFieldAttribute('data', 'required', 'false');
        $form->setFieldAttribute('data', 'disabled', 'true');

        $fields = $this->loadFormFields();
        $form->setField($fields);

        if (isset($this->getData()->review_message)) {  $form->setValue("payment_standard_review_message", null, $this->getData()->review_message); }
        if (isset($this->getData()->confirmation_message)) {  $form->setValue("payment_standard_confirmation_message", null, $this->getData()->confirmation_message); }

        return $form;
    }

    public function onSaveAdminForm($data) {

        $object = new \stdClass();

        $object->review_message = $data['payment_standard_review_message'];
        $object->confirmation_message = $data['payment_standard_confirmation_message'];

        $this->setData($object);

        return true;
    }

    public function getMethodReviewContent($lineitemcontainer, $isContentForMail) {
        $data = $this->getData();
        if (null == $data) {
            return "";
        }
        $string = new Localizablestring($data->review_message);
        return $string->get();

    }


    public function getMethodConfirmContent($lineitemcontainer, $isContentForMail) {
        $data = $this->getData();
        if (null == $data) {
            return "";
        }
        $string = new Localizablestring($data->confirmation_message);
        return $string->get();
    }

}
