<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Plugin\EventgalleryShipping\Standard\Workingclass;

use Joomla\CMS\Factory;
use Svenbluege\Component\Eventgallery\Site\Library\Enum\BasketType;
use Svenbluege\Component\Eventgallery\Site\Library\LineitemContainer;
use Svenbluege\Component\Eventgallery\Site\Library\Methods\ShippingMethod;

defined('_JEXEC') or die();

class Standard extends ShippingMethod
{
    public function __construct($object)
    {
        Factory::getApplication()->bootPlugin('standard', 'eventgallery_ship');
        parent::__construct($object);
    }


    public function getSupportedBasketTypes() {
        return [BasketType::TYPE_PHYSICAL, BasketType::TYPE_MIXED];
    }

    static public  function getClassName() {
        return "Shipping: Standard Ground";
    }
}
