<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Plugin\System\EventgalleryCapabilitiesReport\Extension;


use Joomla\CMS\Plugin\CMSPlugin;

defined('_JEXEC') or die;

class EventgalleryCapabilitiesReport extends CMSPlugin
{
    public function init() {
        $this->loadLanguage();
    }

    public function onPrivacyCollectAdminCapabilities()
    {
        // If a plugin does not have its language files autoloaded, ensure you manually load the language files now otherwise the below may not be translated
        $this->loadLanguage();

        return array(
            \Joomla\CMS\Language\Text::_('PLG_SYSTEM_EVENTGALLERY_CAPABILITIES_REPORT_EXTENSION_NAME') => array(
                \Joomla\CMS\Language\Text::_('PLG_SYSTEM_EVENTGALLERY_CAPABILITIES_REPORT_COOKIES'),
                \Joomla\CMS\Language\Text::_('PLG_SYSTEM_EVENTGALLERY_CAPABILITIES_REPORT_GOOGLEPHOTOS'),
                \Joomla\CMS\Language\Text::_('PLG_SYSTEM_EVENTGALLERY_CAPABILITIES_REPORT_FLICKR'),
                \Joomla\CMS\Language\Text::_('PLG_SYSTEM_EVENTGALLERY_CAPABILITIES_REPORT_S3'),
                \Joomla\CMS\Language\Text::_('PLG_SYSTEM_EVENTGALLERY_CAPABILITIES_REPORT_CHECKOUT'),
                \Joomla\CMS\Language\Text::_('PLG_SYSTEM_EVENTGALLERY_CAPABILITIES_REPORT_PAYMENT_STRIPE'),
                \Joomla\CMS\Language\Text::_('PLG_SYSTEM_EVENTGALLERY_CAPABILITIES_REPORT_PAYMENT_PAYPAL'),
                \Joomla\CMS\Language\Text::_('PLG_SYSTEM_EVENTGALLERY_CAPABILITIES_REPORT_PAYMENT_BRAINTREE'),
                \Joomla\CMS\Language\Text::_('PLG_SYSTEM_EVENTGALLERY_CAPABILITIES_REPORT_SHARING'),
                \Joomla\CMS\Language\Text::_('PLG_SYSTEM_EVENTGALLERY_CAPABILITIES_REPORT_LOGS'),
                \Joomla\CMS\Language\Text::_('PLG_SYSTEM_EVENTGALLERY_CAPABILITIES_REPORT_YOUTUBE'),
            ),
        );
    }

}
