<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Plugin\System\EventgalleryConsole\Extension;
use Joomla\Application\Event\ApplicationEvent;
use Joomla\CMS\Console\Loader\WritableLoaderInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Component\Eventgallery\Site\Library\Commands;
use Joomla\DI\Container;
use Joomla\Event\SubscriberInterface;
use Svenbluege\Component\Eventgallery\Administrator\CliCommand\CreateLocalThumbnails;
use Svenbluege\Component\Eventgallery\Administrator\CliCommand\CreateS3Thumbnails;
use Svenbluege\Component\Eventgallery\Administrator\CliCommand\MigrateGooglePhotos;
use Svenbluege\Component\Eventgallery\Administrator\CliCommand\Sync;

defined('_JEXEC') or die;

/**
 * Adds commands to the Joomla console
 *
 * @package     Joomla.Plugin
 * @since       2.5
 */
class EventgalleryConsole extends CMSPlugin implements SubscriberInterface
{

    public function init() {
        $this->loadLanguage();
    }
    public static function getSubscribedEvents(): array
    {
        return [
            \Joomla\Application\ApplicationEvents::BEFORE_EXECUTE => 'registerCommand',
        ];
    }

    public function registerCommand(ApplicationEvent $event): void
    {
        $serviceId = 'eventgallery.create-local-thumbnails';

        Factory::getContainer()->share(
            $serviceId,
            function (Container $container) {
                // do stuff to create command class and return it
                return new CreateLocalThumbnails();
            },
            true
        );

        Factory::getContainer()->get(WritableLoaderInterface::class)->add(CreateLocalThumbnails::getDefaultName(), $serviceId);

        $serviceId = 'eventgallery.create-s3-thumbnails';

        Factory::getContainer()->share(
            $serviceId,
            function (Container $container) {
                // do stuff to create command class and return it
                return new CreateS3Thumbnails();
            },
            true
        );

        Factory::getContainer()->get(WritableLoaderInterface::class)->add(CreateS3Thumbnails::getDefaultName(), $serviceId);

        $serviceId = 'eventgallery.sync';

        Factory::getContainer()->share(
            $serviceId,
            function (Container $container) {
                // do stuff to create command class and return it
                return new Sync();
            },
            true
        );

        Factory::getContainer()->get(WritableLoaderInterface::class)->add(Sync::getDefaultName(), $serviceId);

        $serviceId = 'eventgallery.migrate-google-photos';

        Factory::getContainer()->share(
            $serviceId,
            function (Container $container) {
                // do stuff to create command class and return it
                return new MigrateGooglePhotos();
            },
            true
        );

        Factory::getContainer()->get(WritableLoaderInterface::class)->add(MigrateGooglePhotos::getDefaultName(), $serviceId);
    }

}



